<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-24 18:07:23
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Milestone
 * @method createByParams(array $params) 创建里程碑
 * @method updateByParams(array $params) 编辑里程碑
 * @method updateStateByParams(array $params) 里程碑上下架
 * @method infoByParams(array $params) 里程碑详情
 * @method allByParams(array $params) 获取全部里程碑数据
 * @method showByParams(array $params) 商品组展示
 * @method hiddenByParams(array $params) 商品组隐藏
 */
class Milestone {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\Milestone\\Milestone";

    /**
     * 创建里程碑
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneCreateDTO
    */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneCreateCmd $milestoneCreateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($milestoneCreateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneCreateDTO"
        );
    }

    /**
     * 编辑里程碑
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateCmd $milestoneUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($milestoneUpdateCmd);
    }

    /**
     * 里程碑上下架
     * @return  bool
    */
    public static function updateState (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneUpdateStateCmd $milestoneUpdateStateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateState($milestoneUpdateStateCmd);
    }

    /**
     * 里程碑详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO
    */
    public static function info (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO"
        );
    }

    /**
     * 获取全部里程碑数据
     * @return  array
    */
    public static function all (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneAllCmd $milestoneAllCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->all($milestoneAllCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneInfoDTO[]"
        );
    }

    /**
     * 商品组展示
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function show (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->show(["id" => $id]);
    }

    /**
     * 商品组隐藏
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hidden (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hidden(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}