<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-28 18:27:19
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MemberCardTemplateManage
 * @method detailByParams(array $params) 获取会员卡模板详情
 * @method createTemplateByParams(array $params) 创建会员卡模板
 * @method updateTemplateByParams(array $params) 编辑会员卡模板
 * @method modifyTemplateStateByParams(array $params) 修改会员卡模板状态
 * @method listByParams(array $params) 获取会员卡模板列表--分页
 */
class MemberCardTemplateManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\MemberCardTemplateManage";

    /**
     * 获取会员卡模板详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateDetailDTO
    */
    public static function detail (int $template_id, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(array_merge($_params, ["template_id" => $template_id])),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateDetailDTO"
        );
    }

    /**
     * 创建会员卡模板
     * @return  bool
    */
    public static function createTemplate (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateCreateCmd $templateCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTemplate($templateCreateCmd);
    }

    /**
     * 编辑会员卡模板
     * @return  bool
    */
    public static function updateTemplate (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateUpdateCmd $templateUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTemplate($templateUpdateCmd);
    }

    /**
     * 修改会员卡模板状态
     * @return  bool
    */
    public static function modifyTemplateState (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\TemplateStateModifyCmd $templateStateModifyCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyTemplateState($templateStateModifyCmd);
    }

    /**
     * 获取会员卡模板列表--分页
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\Cmd\MemberCardTemplateListCmd $memberCardTemplateListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($memberCardTemplateListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCardTemplate\DTO\MemberCardTemplateListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}