<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-28 18:11:31
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RedEnvelopeActivity
 * @method getUserBehaviorsByParams(array $params) 获取用户行为记录列表
 * @method getUserBehaviorsByUserIdByParams(array $params) 通过userId获取用户行为记录列表
 * @method createUserBehaviorRecordByParams(array $params) 创建用户行为记录
 * @method createUserBehaviorRecordByUserIdByParams(array $params) 通过userId创建用户行为记录
 * @method getUserIdsByBehaviorByParams(array $params) 通过behavior获取对应的userId列表--预约端调用
 * @method getActivityInfoByParams(array $params) 获取新年活动信息
 * @method getPosterQrcodeByParams(array $params) 获取红包活动分享海报二维码
 * @method getRedEnvelopeAmountDetailsByParams(array $params) 获取红包金额明细
 * @method getParticipationDetailByParams(array $params) 用户参与详情
 * @method getAssistanceRedEnvelopeDetailByParams(array $params) 获取用户惊喜红包详情
 * @method openRedEnvelopeByParams(array $params) 开红包
 * @method getUserInfoByUserIdByParams(array $params) 根据id获取用户脱敏详情
 * @method resetUserBehaviorRecordByParams(array $params) 重置用户行为记录
 */
class RedEnvelopeActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\RedEnvelopeActivity";

    /**
     * 获取用户行为记录列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO
    */
    public static function getUserBehaviors () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }

    /**
     * 通过userId获取用户行为记录列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO
    */
    public static function getUserBehaviorsByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviorsByUserId(["userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }

    /**
     * 创建用户行为记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createUserBehaviorRecord (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecord(array_merge($_params, []));
    }

    /**
     * 通过userId创建用户行为记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createUserBehaviorRecordByUserId (int $userId, string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecordByUserId(["userId" => $userId, "behavior" => $behavior]);
    }

    /**
     * 通过behavior获取对应的userId列表--预约端调用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserIdsByBehavior (string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByBehavior(["behavior" => $behavior]);
    }

    /**
     * 获取新年活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 获取红包活动分享海报二维码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getPosterQrcode (int $greetingId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPosterQrcode(array_merge($_params, ["greetingId" => $greetingId]));
    }

    /**
     * 获取红包金额明细
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getRedEnvelopeAmountDetails () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRedEnvelopeAmountDetails();
    }

    /**
     * 用户参与详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getParticipationDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParticipationDetail();
    }

    /**
     * 获取用户惊喜红包详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAssistanceRedEnvelopeDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssistanceRedEnvelopeDetail();
    }

    /**
     * 开红包
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function openRedEnvelope (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->openRedEnvelope(array_merge($_params, []));
    }

    /**
     * 根据id获取用户脱敏详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserInfoByUserId (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoByUserId(["userId" => $userId]);
    }

    /**
     * 重置用户行为记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function resetUserBehaviorRecord (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetUserBehaviorRecord(array_merge($_params, []));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}