<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-28 18:11:31
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StudentMember
 * @method memberDiscountProductCategoriesListByParams(array $params) 获取会员优惠产品类目列表
 * @method getReceiveCouponActivityConfigByParams(array $params) 获取领券活动配置
 * @method checkMemberStudentIdentifyByParams(array $params) 检查会员学生身份
 * @method certifiedStudentIdentifyByParams(array $params) 认证学生身份
 * @method receiveMemberCouponByParams(array $params) 领取会员优惠券
 * @method getMemberCouponReceiveInfoByParams(array $params) 获取会员优惠券领取信息
 * @method usedStudentCertificateTagByParams(array $params) 使用学生认证标签
 * @method getStudentMemberQrcodeByParams(array $params) 获取学生会员码
 * @method verifyStudentMemberQrcodeByParams(array $params) 核验学生码
 * @method verifyNonStudentMemberQrcodeByParams(array $params) 核验会员码--非学生会员订单
 * @method certifiedStudentIdentifyByWxByParams(array $params) 通过微信认证学生身份
 * @method getUserEquityInfoByParams(array $params) 获取用户权益信息
 * @method getTimeLimitedCategoryInfoByParams(array $params) 获取限时产品组信息
 * @method getNormalCategoryInfoByParams(array $params) 获取常规产品组信息
 * @method receiveEquityRewardByParams(array $params) 通过产品组id领取学生权益奖励
 * @method certifiedStudentIdentifyByAlipayByParams(array $params) 通过支付宝认证学生身份
 * @method zhimaPreconsultByParams(array $params) alipay芝麻验证咨询
 * @method zhimaIdentifyQueryByParams(array $params) alipay芝麻身份认证查询
 */
class StudentMember {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\StudentMember";

    /**
     * 获取会员优惠产品类目列表
     * @return  mixed
    */
    public static function memberDiscountProductCategoriesList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberDiscountProductCategoriesList();
    }

    /**
     * 获取领券活动配置
     * @return  string
    */
    public static function getReceiveCouponActivityConfig () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReceiveCouponActivityConfig();
    }

    /**
     * 检查会员学生身份
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function checkMemberStudentIdentify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkMemberStudentIdentify();
    }

    /**
     * 认证学生身份
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function certifiedStudentIdentify (string $token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->certifiedStudentIdentify(array_merge($_params, ["token" => $token]));
    }

    /**
     * 领取会员优惠券
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function receiveMemberCoupon (int $template_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveMemberCoupon(array_merge($_params, ["template_id" => $template_id]));
    }

    /**
     * 获取会员优惠券领取信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMemberCouponReceiveInfo (int $template_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMemberCouponReceiveInfo(array_merge($_params, ["template_id" => $template_id]));
    }

    /**
     * 使用学生认证标签
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function usedStudentCertificateTag () {
        return RpcClass::getClass(self::$serviceName, self::$className)->usedStudentCertificateTag();
    }

    /**
     * 获取学生会员码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getStudentMemberQrcode () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStudentMemberQrcode();
    }

    /**
     * 核验学生码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function verifyStudentMemberQrcode (string $token, int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifyStudentMemberQrcode(array_merge($_params, ["token" => $token, "orderId" => $orderId]));
    }

    /**
     * 核验会员码--非学生会员订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function verifyNonStudentMemberQrcode (string $token, int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->verifyNonStudentMemberQrcode(array_merge($_params, ["token" => $token, "orderId" => $orderId]));
    }

    /**
     * 通过微信认证学生身份
     * @return  bool
    */
    public static function certifiedStudentIdentifyByWx (\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\WxCertifiedStudentIdentifyCMD $wxCertifiedStudentIdentifyCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->certifiedStudentIdentifyByWx($wxCertifiedStudentIdentifyCMD);
    }

    /**
     * 获取用户权益信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\UserEquityInfoDTO
    */
    public static function getUserEquityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserEquityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\UserEquityInfoDTO"
        );
    }

    /**
     * 获取限时产品组信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\TimeLimitedCategoryInfoDTO
    */
    public static function getTimeLimitedCategoryInfo (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\GetCategoryInfoCMD $getCategoryInfoCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTimeLimitedCategoryInfo($getCategoryInfoCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\TimeLimitedCategoryInfoDTO"
        );
    }

    /**
     * 获取常规产品组信息
     * @return  array
    */
    public static function getNormalCategoryInfo (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\GetCategoryInfoCMD $getCategoryInfoCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNormalCategoryInfo($getCategoryInfoCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\NormalCategoryInfoDTO[]"
        );
    }

    /**
     * 通过产品组id领取学生权益奖励
     * @return  bool
    */
    public static function receiveEquityReward (\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\ReceiveEquityRewardCMD $receiveEquityRewardCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveEquityReward($receiveEquityRewardCMD);
    }

    /**
     * 通过支付宝认证学生身份
     * @return  bool
    */
    public static function certifiedStudentIdentifyByAlipay (\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\AlipayCertifiedStudentIdentifyCMD $alipayCertifiedStudentIdentifyCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->certifiedStudentIdentifyByAlipay($alipayCertifiedStudentIdentifyCMD);
    }

    /**
     * alipay芝麻验证咨询
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\ZhimaIdentifyPreconsultDTO
    */
    public static function zhimaPreconsult (\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\ZhimaIdentifyPreconsultCMD $zhimaIdentifyPreconsultCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->zhimaPreconsult($zhimaIdentifyPreconsultCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\ZhimaIdentifyPreconsultDTO"
        );
    }

    /**
     * alipay芝麻身份认证查询
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\ZhimaIdentifyQueryDTO
    */
    public static function zhimaIdentifyQuery (\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\CMD\ZhimaIdentifyQueryCMD $zhimaIdentifyQueryCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->zhimaIdentifyQuery($zhimaIdentifyQueryCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\StudentMember\DTO\ZhimaIdentifyQueryDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}