<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-20 11:36:24
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method getPreferentialPageActivityListByParams(array $params) 获取领券活动页
 * @method getMaintoProductByParams(array $params) 缦图产品列表
 * @method getPeopleCountByParams(array $params) 根据筛选条件获取人数
 * @method upLoadImageByParams(array $params) 上传图片
 * @method getManagerInfoByParams(array $params) 获取管理员信息
 * @method getStoreListByCityIdByParams(array $params) 根据城市id获取门店企业微信信息
 * @method getActivityAvailableStoreListByParams(array $params) 获取活动可用门店列表Ids
 * @method getAvailableStoreTreeByParams(array $params) 获取可参与活动的门店树
 * @method getProductDiscountListByParams(array $params) 批量获取产品的折扣规则
 * @method getMostNearestStoreByParams(array $params) 获取活动门店中距离最近的门店
 * @method getMostNearestStoreByBrandByParams(array $params) 通过品牌获取最近的门店
 * @method getActivityLinkParameterByParams(array $params) 获取活动链接参数
 * @method saveActivityLinkParameterByParams(array $params) 保存活动链接参数
 * @method getMiniUrlLinkByParams(array $params) 获取微信小程序UrlLink
 * @method getQrcodeByParams(array $params) 获取二维码
 * @method getAvailableStoreIdsByProductIdsByParams(array $params) 根据产品id列表获取可用门店
 * @method getCategoryProductInfoByParams(array $params) 获取产品组产品信息
 * @method getCategoryDetailByParams(array $params) 获取产品组详情
 * @method subscribeMessageByParams(array $params) 订阅小程序消息
 * @method getPreferentialTemplateListByParams(array $params) 分页获取优惠券列表
 * @method getUserFinishPhotoListByParams(array $params) 获取成片列表
 * @method imageCensorByParams(array $params) 图片内容审核
 * @method isSubscribedMessageByParams(array $params) 是否已订阅过当前事件
 * @method getUserBaseInfoByParams(array $params) 获取用户基础信息
 * @method getCurrentServerTimestampByParams(array $params) 获取服务器当前时间戳
 * @method convertToBase64ByParams(array $params) 转换内容为base64
 * @method getProvinceListByParams(array $params) 获取省份列表
 * @method createCounterByParams(array $params) 创建一个计数器
 * @method setCounterRemainingByParams(array $params) 设置计数器剩余
 * @method getCounterRemainingByParams(array $params) 获取计数器剩余
 * @method createUserBehaviorByParams(array $params) 创建用户行为记录
 * @method isUserBehaviorExistsByParams(array $params) 用户行为是否存在
 * @method isRiskUserByParams(array $params) 用户风控查询
 * @method createExcelParseTaskByParams(array $params) 创建 excel 解析任务
 * @method getExcelParseTaskByParams(array $params) 查询 excel 解析任务
 * @method getSpuTagConfigPageByParams(array $params) 查询产品组标签配置分页数据
 */
class Common {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Common\\Common";

    /**
     * 获取领券活动页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPreferentialPageActivityList (int $page = 1, int $page_size = 10, bool $all = true, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialPageActivityList(array_merge($_params, ["page" => $page, "page_size" => $page_size, "all" => $all]));
    }

    /**
     * 缦图产品列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getMaintoProduct (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaintoProduct(array_merge($_params, []));
    }

    /**
     * 根据筛选条件获取人数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function getPeopleCount (array $tags, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPeopleCount(array_merge($_params, ["tags" => $tags]));
    }

    /**
     * 上传图片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function upLoadImage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upLoadImage(array_merge($_params, []));
    }

    /**
     * 获取管理员信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getManagerInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManagerInfo();
    }

    /**
     * 根据城市id获取门店企业微信信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreListByCityId (array $city_ids, array $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId(["city_ids" => $city_ids, "store_type" => $store_type]);
    }

    /**
     * 获取活动可用门店列表Ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getActivityAvailableStoreList (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityAvailableStoreList(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 获取可参与活动的门店树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAvailableStoreTree (int $product_category_id, string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreTree(array_merge($_params, ["product_category_id" => $product_category_id, "brand" => $brand]));
    }

    /**
     * 批量获取产品的折扣规则
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getProductDiscountList (array $discount_rule_ids, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDiscountList(array_merge($_params, ["discount_rule_ids" => $discount_rule_ids]));
    }

    /**
     * 获取活动门店中距离最近的门店
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getMostNearestStore (array $location, int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStore(array_merge($_params, ["location" => $location, "activity_id" => $activity_id]));
    }

    /**
     * 通过品牌获取最近的门店
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getMostNearestStoreByBrand (array $location, string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStoreByBrand(array_merge($_params, ["location" => $location, "brand" => $brand]));
    }

    /**
     * 获取活动链接参数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getActivityLinkParameter (int $link_parameter_id, int $index, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityLinkParameter(array_merge($_params, ["link_parameter_id" => $link_parameter_id, "index" => $index]));
    }

    /**
     * 保存活动链接参数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function saveActivityLinkParameter ( $activity_id, array $link_parameter, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveActivityLinkParameter(array_merge($_params, ["activity_id" => $activity_id, "link_parameter" => $link_parameter]));
    }

    /**
     * 获取微信小程序UrlLink
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMiniUrlLink (string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniUrlLink(array_merge($_params, ["path" => $path]));
    }

    /**
     * 获取二维码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getQrcode (string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQrcode(array_merge($_params, ["path" => $path]));
    }

    /**
     * 根据产品id列表获取可用门店
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAvailableStoreIdsByProductIds (array $product_ids, array $store_ids, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreIdsByProductIds(array_merge($_params, ["product_ids" => $product_ids, "store_ids" => $store_ids]));
    }

    /**
     * 获取产品组产品信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getCategoryProductInfo (int $activity_id, int $category_id, int $store_id, int $city_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductInfo(array_merge($_params, ["activity_id" => $activity_id, "category_id" => $category_id, "store_id" => $store_id, "city_id" => $city_id]));
    }

    /**
     * 获取产品组详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCategoryDetail (int $category_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryDetail(array_merge($_params, ["category_id" => $category_id]));
    }

    /**
     * 订阅小程序消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function subscribeMessage (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->subscribeMessage(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * 分页获取优惠券列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO
    */
    public static function getPreferentialTemplateList (\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\Cmd\PreferentialTemplateListCmd $preferentialTemplateListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialTemplateList($preferentialTemplateListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO"
        );
    }

    /**
     * 获取成片列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO
    */
    public static function getUserFinishPhotoList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\Cmd\UserFinishPhotoListCmd $userFinishPhotoListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserFinishPhotoList($userFinishPhotoListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO"
        );
    }

    /**
     * 图片内容审核
     * @return  bool
    */
    public static function imageCensor (\Mainto\Bridge\Structs\ProjectCrm\Common\ImageCensor\Cmd\GreenImageCheckCmd $greenImageCheckCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->imageCensor($greenImageCheckCmd);
    }

    /**
     * 是否已订阅过当前事件
     * @return  bool
    */
    public static function isSubscribedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SubscribeMessage\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isSubscribedMessage($subscribedMessageCheckCmd);
    }

    /**
     * 获取用户基础信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO
    */
    public static function getUserBaseInfo (\Mainto\Bridge\Structs\ProjectCrm\Common\User\Cmd\UserBaseInfoCmd $userBaseInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBaseInfo($userBaseInfoCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO"
        );
    }

    /**
     * 获取服务器当前时间戳
     * @return  string
    */
    public static function getCurrentServerTimestamp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentServerTimestamp();
    }

    /**
     * 转换内容为base64
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function convertToBase64 (string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->convertToBase64(["content" => $content]);
    }

    /**
     * 获取省份列表
     * @return  array
    */
    public static function getProvinceList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProvinceList(),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\Area\DTO\ProvinceInfoDTO[]"
        );
    }

    /**
     * 创建一个计数器
     * @return  bool
    */
    public static function createCounter (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\CreateCounterCMD $createCounterCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createCounter($createCounterCMD);
    }

    /**
     * 设置计数器剩余
     * @return  bool
    */
    public static function setCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\SetCounterRemainingCMD $setCounterRemainingCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCounterRemaining($setCounterRemainingCMD);
    }

    /**
     * 获取计数器剩余
     * @return  int
    */
    public static function getCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\GetCounterRemainingCMD $getCounterRemainingCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCounterRemaining($getCounterRemainingCMD);
    }

    /**
     * 创建用户行为记录
     * @return  bool
    */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\CreateUserBehaviorCMD $createUserBehaviorCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehavior($createUserBehaviorCMD);
    }

    /**
     * 用户行为是否存在
     * @return  bool
    */
    public static function isUserBehaviorExists (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\BehaviorExistsCheckCMD $behaviorExistsCheckCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isUserBehaviorExists($behaviorExistsCheckCMD);
    }

    /**
     * 用户风控查询
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function isRiskUser () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isRiskUser();
    }

    /**
     * 创建 excel 解析任务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function createExcelParseTask (string $filePath, string $sceneValue, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createExcelParseTask(array_merge($_params, ["filePath" => $filePath, "sceneValue" => $sceneValue]));
    }

    /**
     * 查询 excel 解析任务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getExcelParseTask (string $taskId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExcelParseTask(array_merge($_params, ["taskId" => $taskId]));
    }

    /**
     * 查询产品组标签配置分页数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getSpuTagConfigPage (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpuTagConfigPage(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}