<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-29 14:46:38
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MemberProperty
 * @method getCouponListByParams(array $params) 按品牌获取优惠券列表
 * @method getProductCardListByParams(array $params) 按品牌获取产品卡列表
 * @method getGiftCardListByParams(array $params) 按品牌获取礼品卡列表
 * @method getFlowListByParams(array $params) 获取用户流水
 * @method allPropertyByParams(array $params) 获取资产汇总信息
 * @method searchGiftCardDetailsByParams(array $params) 获取礼品卡使用明细
 * @method getMedalListByParams(array $params) 获取勋章明细
 */
class MemberProperty {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\MemberProperty";

    /**
     * 按品牌获取优惠券列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCouponList (int $user_id, int $page = 1, int $page_size = 5, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponList(array_merge($_params, ["user_id" => $user_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 按品牌获取产品卡列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getProductCardList (int $user_id, int $page = 1, int $page_size = 5, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardList(array_merge($_params, ["user_id" => $user_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 按品牌获取礼品卡列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGiftCardList (int $user_id, int $page = 1, int $page_size = 5, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardList(array_merge($_params, ["user_id" => $user_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 获取用户流水
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getFlowList (int $user_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFlowList(array_merge($_params, ["user_id" => $user_id]));
    }

    /**
     * 获取资产汇总信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberProperty\DTO\PropertySummaryInfoDTO
    */
    public static function allProperty (int $user_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allProperty(["user_id" => $user_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberProperty\DTO\PropertySummaryInfoDTO"
        );
    }

    /**
     * 获取礼品卡使用明细
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function searchGiftCardDetails (int $gift_card_id, int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchGiftCardDetails(array_merge($_params, ["gift_card_id" => $gift_card_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 获取勋章明细
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMedalList (int $user_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMedalList(array_merge($_params, ["user_id" => $user_id]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}