<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-20 15:40:10
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\MessageBoard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MessageBoard
 * @method getActivityInfoByParams(array $params) 获取毕业留言板活动信息
 * @method getMessageListByParams(array $params) 查询所有用户留言列表
 * @method getMyMessageListByParams(array $params) 查询我的留言板内容列表
 * @method createMessageByParams(array $params) 创建一条留言内容
 */
class MessageBoard {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\MessageBoard\\MessageBoard";

    /**
     * 获取毕业留言板活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 查询所有用户留言列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO
    */
    public static function getMessageList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMessageList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO"
        );
    }

    /**
     * 查询我的留言板内容列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO
    */
    public static function getMyMessageList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\Cmd\MessageBoarQueryCMD $messageBoarQueryCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyMessageList($messageBoarQueryCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO"
        );
    }

    /**
     * 创建一条留言内容
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createMessage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createMessage(array_merge($_params, []));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}