<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-17 10:41:17
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Member
 * @method memberListByParams(array $params) 获取会员列表
 * @method memberElementaryMessageByParams(array $params) 获取会员基础信息
 * @method memberEsMessageByParams(array $params) 获取会员聚合信息(从es获取的统计类数据)
 * @method memberOrderListByParams(array $params) 按品牌获取订单列表
 * @method sendBirthCouponByParams(array $params) 补发生日券
 * @method isMemberOrderNeedCheckByParams(array $params) 会员订单是否需要门店核验
 */
class Member {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\Member";

    /**
     * 获取会员列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function memberList (int $page = 1, int $page_size = 5, string $sort_by = 'user_regis_time', string $sort_type = 'desc', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberList(array_merge($_params, ["page" => $page, "page_size" => $page_size, "sort_by" => $sort_by, "sort_type" => $sort_type]));
    }

    /**
     * 获取会员基础信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function memberElementaryMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberElementaryMessage(["user_id" => $user_id]);
    }

    /**
     * 获取会员聚合信息(从es获取的统计类数据)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function memberEsMessage (int $user_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberEsMessage(array_merge($_params, ["user_id" => $user_id]));
    }

    /**
     * 按品牌获取订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function memberOrderList (int $user_id, int $page = 1, int $page_size = 5, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberOrderList(array_merge($_params, ["user_id" => $user_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 补发生日券
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function sendBirthCoupon (int $userId, int $stepYear = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendBirthCoupon(array_merge($_params, ["userId" => $userId, "stepYear" => $stepYear]));
    }

    /**
     * 会员订单是否需要门店核验
     * @return  bool
    */
    public static function isMemberOrderNeedCheck (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Member\Cmd\MemberOrderNeedCheckCMD $memberOrderNeedCheckCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isMemberOrderNeedCheck($memberOrderNeedCheckCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}