<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-15 15:27:19
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SpreadPlan
 * @method createSpreadPlanByParams(array $params) 创建推广计划
 * @method editSpreadPlanByParams(array $params) 编辑推广计划
 * @method cancelSpreadPlanByParams(array $params) 推广计划取消
 * @method deleteSpreadPlanByParams(array $params) 删除推广计划
 * @method spreadPlanDetailByParams(array $params) 推广计划详情
 * @method spreadPlanListByParams(array $params) 推广计划列表
 */
class SpreadPlan {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Push\\SpreadPlan";

    /**
     * 创建推广计划
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function createSpreadPlan (string $relation_activity_id, array $filter_condition, array $push_content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpreadPlan(array_merge($_params, ["relation_activity_id" => $relation_activity_id, "filter_condition" => $filter_condition, "push_content" => $push_content]));
    }

    /**
     * 编辑推广计划
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function editSpreadPlan (int $task_id, string $relation_activity_id, array $filter_condition, array $push_content, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSpreadPlan(array_merge($_params, ["task_id" => $task_id, "relation_activity_id" => $relation_activity_id, "filter_condition" => $filter_condition, "push_content" => $push_content]));
    }

    /**
     * 推广计划取消
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelSpreadPlan (int $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelSpreadPlan(["task_id" => $task_id]);
    }

    /**
     * 删除推广计划
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteSpreadPlan (int $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSpreadPlan(["task_id" => $task_id]);
    }

    /**
     * 推广计划详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO
    */
    public static function spreadPlanDetail (int $task_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanDetail(["task_id" => $task_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO"
        );
    }

    /**
     * 推广计划列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO
    */
    public static function spreadPlanList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\Cmd\PushTaskListCmd $pushTaskListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanList($pushTaskListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}