<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-09 17:49:23
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ActivityPage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ActivityPage
 * @method searchByIdByParams(array $params) 单个活动查询[用户端]
 * @method receiveCouponByParams(array $params) 用户领券 - 通过手机号验证码
 * @method receiveCouponByAuthByParams(array $params) 用户领券 - 需授权登录
 * @method getJsSdkByParams(array $params) 获取微信签名jssdk配置
 * @method appointmentReceiveCouponByAuthByParams(array $params) 预约端专用 - 用户领券.鉴权
 */
class ActivityPage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\ActivityPage\\ActivityPage";

    /**
     * 单个活动查询[用户端]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function searchById (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchById(["_id" => $_id]);
    }

    /**
     * 用户领券 - 通过手机号验证码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function receiveCoupon (string $_id, string $phone, string $token, string $code = '', string $receiveChannel = '', int $orderId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveCoupon(["_id" => $_id, "phone" => $phone, "token" => $token, "code" => $code, "receiveChannel" => $receiveChannel, "orderId" => $orderId]);
    }

    /**
     * 用户领券 - 需授权登录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function receiveCouponByAuth (string $_id, string $phone, string $token, string $receiveChannel = '', int $orderId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveCouponByAuth(["_id" => $_id, "phone" => $phone, "token" => $token, "receiveChannel" => $receiveChannel, "orderId" => $orderId]);
    }

    /**
     * 获取微信签名jssdk配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getJsSdk (string $_id, string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getJsSdk(["_id" => $_id, "url" => $url]);
    }

    /**
     * 预约端专用 - 用户领券.鉴权
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function appointmentReceiveCouponByAuth (string $_id, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->appointmentReceiveCouponByAuth(["_id" => $_id, "phone" => $phone]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}