<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-14 11:00:01
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SubscribeMessagePush
 * @method handleSubscribeMessageCronTemplateByParams(array $params) 订阅通知定时处理。每分钟执行1次
 * @method handleSubscribeMessageForSettingByParams(array $params) 处理需要订阅推送模版，找出需要推送的事件
 * @method handleSubscribeMessageForSettingAndEventByParams(array $params) 处理需要订阅推送的模版事件，找出需要推送的人
 * @method handleSubscribeMessageToUserByParams(array $params) 推送事件消息通知到人
 */
class SubscribeMessagePush {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Cron\\SubscribeMessagePush";

    /**
     * 订阅通知定时处理。每分钟执行1次
     * @return  bool
    */
    public static function handleSubscribeMessageCronTemplate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSubscribeMessageCronTemplate();
    }

    /**
     * 处理需要订阅推送模版，找出需要推送的事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleSubscribeMessageForSetting (string $settingName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSubscribeMessageForSetting(array_merge($_params, ["settingName" => $settingName]));
    }

    /**
     * 处理需要订阅推送的模版事件，找出需要推送的人
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleSubscribeMessageForSettingAndEvent (string $settingName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSubscribeMessageForSettingAndEvent(array_merge($_params, ["settingName" => $settingName]));
    }

    /**
     * 推送事件消息通知到人
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleSubscribeMessageToUser (int $eventId, string $openId, string $settingName, string $eventName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSubscribeMessageToUser(array_merge($_params, ["eventId" => $eventId, "openId" => $openId, "settingName" => $settingName, "eventName" => $eventName]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}