<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-10 15:28:00
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Manager
 * @method listByParams(array $params) 获取管理员列表
 * @method createByParams(array $params) 创建管理员
 * @method enableByParams(array $params) 修改管理员启用状态
 * @method detailByParams(array $params) 获取管理员
 * @method grantRoleByParams(array $params) 给管理员授权角色
 * @method grantPermissionsByParams(array $params) 给管理员授权权限
 * @method searchStaffByParams(array $params) 通过伙伴姓名或花名获得可能的工号
 */
class Manager {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Auth\\Manager";

    /**
     * 获取管理员列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerListCmd $managerListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($managerListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerListDTO"
        );
    }

    /**
     * 创建管理员
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(array_merge($_params, []));
    }

    /**
     * 修改管理员启用状态
     * @return  bool
    */
    public static function enable (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerStatusModifyCmd $managerStatusModifyCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enable($managerStatusModifyCmd);
    }

    /**
     * 获取管理员
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerDetailDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerDetailDTO"
        );
    }

    /**
     * 给管理员授权角色
     * @return  bool
    */
    public static function grantRole (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerRoleGrantCmd $managerRoleGrantCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole($managerRoleGrantCmd);
    }

    /**
     * 给管理员授权权限
     * @return  bool
    */
    public static function grantPermissions (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerPermissionGrantCmd $managerPermissionGrantCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantPermissions($managerPermissionGrantCmd);
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchStaff (string $staff_name) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchStaff(["staff_name" => $staff_name]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\StaffInfoDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}