<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-15 17:22:58
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Activity
 * @method handleActivityOrderPaidByParams(array $params) 处理活动订单支付成功事件
 * @method handleActivityOrderRefundByParams(array $params) 处理活动订单退款事件
 * @method handleActivityOrderCancelByParams(array $params) 处理活动订单取消事件
 * @method inviteeJoinRewardSponsorByParams(array $params) 受邀者加入奖励发起者
 * @method resetMemberEffectiveTimeByParams(array $params) 重置活动发起人的活动有效时间
 * @method handleActivityPeriodExpireByParams(array $params) 处理发起人活动周期到期的schedule
 * @method handleActivityOrderServiceCompletedByParams(array $params) 处理活动订单服务完成事件
 * @method handleActivityWechatWorkCallbackByParams(array $params) 处理企业微信回调事件
 * @method distributeLotteryAwardByParams(array $params) 抽奖活动开奖奖品分发事件
 * @method notifyLotteryTimeDrawByParams(array $params) 抽奖活动开奖通知
 * @method updateLotteryActivityMemberUserLevelByParams(array $params) 会员等级变动，更新抽奖用户的会员等级冗余字段
 * @method setMemberLotteryNumberByParams(array $params) 用户加入抽奖活动，为用户设置抽奖序号
 * @method distributeConsolationAwardByParams(array $params) 分页发放抽奖活动安慰奖奖励
 * @method sendActivityStartedMessageByParams(array $params) 通知活动开始
 */
class Activity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "MessageHook\\Activity";

    /**
     * 处理活动订单支付成功事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityOrderPaid (int $orderId, int $storeId, int $userId, array $skuList, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityOrderPaid(array_merge($_params, ["orderId" => $orderId, "storeId" => $storeId, "userId" => $userId, "skuList" => $skuList]));
    }

    /**
     * 处理活动订单退款事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityOrderRefund (int $orderId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityOrderRefund(array_merge($_params, ["orderId" => $orderId]));
    }

    /**
     * 处理活动订单取消事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityOrderCancel (int $orderId, int $storeId, int $userId, array $skuList, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityOrderCancel(array_merge($_params, ["orderId" => $orderId, "storeId" => $storeId, "userId" => $userId, "skuList" => $skuList]));
    }

    /**
     * 受邀者加入奖励发起者
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function inviteeJoinRewardSponsor (array $invitee, array $sponsor, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inviteeJoinRewardSponsor(array_merge($_params, ["invitee" => $invitee, "sponsor" => $sponsor]));
    }

    /**
     * 重置活动发起人的活动有效时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function resetMemberEffectiveTime (array $sponsors, string $effectiveEndedTime, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetMemberEffectiveTime(array_merge($_params, ["sponsors" => $sponsors, "effectiveEndedTime" => $effectiveEndedTime]));
    }

    /**
     * 处理发起人活动周期到期的schedule
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityPeriodExpire (array $schedule, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityPeriodExpire(array_merge($_params, ["schedule" => $schedule]));
    }

    /**
     * 处理活动订单服务完成事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityOrderServiceCompleted (int $orderId, array $orderBaseInfo, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityOrderServiceCompleted(array_merge($_params, ["orderId" => $orderId, "orderBaseInfo" => $orderBaseInfo]));
    }

    /**
     * 处理企业微信回调事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleActivityWechatWorkCallback (string $toUserName, string $fromUserName, int $createTime, string $msgType, string $event, string $changeType, string $userId, string $externalUserId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleActivityWechatWorkCallback(array_merge($_params, ["toUserName" => $toUserName, "fromUserName" => $fromUserName, "createTime" => $createTime, "msgType" => $msgType, "event" => $event, "changeType" => $changeType, "userId" => $userId, "externalUserId" => $externalUserId]));
    }

    /**
     * 抽奖活动开奖奖品分发事件
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function distributeLotteryAward (int $activityId, array $userIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->distributeLotteryAward(array_merge($_params, ["activityId" => $activityId, "userIds" => $userIds]));
    }

    /**
     * 抽奖活动开奖通知
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function notifyLotteryTimeDraw (int $activityId, int $userId, string $userFrom, string $activityType, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notifyLotteryTimeDraw(array_merge($_params, ["activityId" => $activityId, "userId" => $userId, "userFrom" => $userFrom, "activityType" => $activityType]));
    }

    /**
     * 会员等级变动，更新抽奖用户的会员等级冗余字段
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateLotteryActivityMemberUserLevel (int $userId, string $currentLevel) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateLotteryActivityMemberUserLevel(["userId" => $userId, "currentLevel" => $currentLevel]);
    }

    /**
     * 用户加入抽奖活动，为用户设置抽奖序号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setMemberLotteryNumber (int $activityId, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setMemberLotteryNumber(["activityId" => $activityId, "userId" => $userId]);
    }

    /**
     * 分页发放抽奖活动安慰奖奖励
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function distributeConsolationAward (int $activityId, int $page) {
        return RpcClass::getClass(self::$serviceName, self::$className)->distributeConsolationAward(["activityId" => $activityId, "page" => $page]);
    }

    /**
     * 通知活动开始
     * @return  bool
    */
    public static function sendActivityStartedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Activity\CMD\NotifyActivityStartedCMD $notifyActivityStartedCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendActivityStartedMessage($notifyActivityStartedCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}