<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-21 09:14:26
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class YouthMemorialBook
 * @method getActivityInfoByParams(array $params) 获取青春纪念册活动信息
 * @method getClassroomListByParams(array $params) 获取班级列表
 * @method bindClassroomByParams(array $params) 绑定活动院校及班级
 * @method getParticipationInfoByParams(array $params) 获取用户毕业季活动信息
 * @method punchInByParams(array $params) 毕业季活动打卡
 * @method updateRecordStatusByParams(array $params) 更新打卡内容状态
 * @method getMyGraduationAlbumByParams(array $params) 获取我的毕业相册
 * @method getMyGraduationMomentListByParams(array $params) 获取我的毕业瞬间列表
 * @method getPunchRecordListByParams(array $params) 获取打卡内容列表
 * @method getPunchRecordDetailByParams(array $params) 获取单条打卡内容详情
 * @method getClassroomDetailByParams(array $params) 获取班级详情信息
 * @method assistancePunchByParams(array $params) 参与协助
 * @method getReceivedGreetingListByParams(array $params) 获取领取到的祝福语
 * @method getTopClassroomListByParams(array $params) 获取班级排名列表
 * @method likePunchRecordByParams(array $params) 点赞记录
 * @method bindClassroomByIdByParams(array $params) 根据班级id绑定班级
 * @method showAwardInfoByParams(array $params) 展示奖励信息
 * @method canAssistanceByParams(array $params) 是否可以参与协助
 * @method confirmAwardInfoByParams(array $params) 确认奖品信息
 * @method createUserBehaviorByParams(array $params) 创建用户行为记录
 * @method isGraduationAlbumGeneratedByParams(array $params) 用户是否已生成过毕业相册
 */
class YouthMemorialBook {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\YouthMemorialBook";

    /**
     * 获取青春纪念册活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 获取班级列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO
    */
    public static function getClassroomList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $classroomListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getClassroomList($classroomListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO"
        );
    }

    /**
     * 绑定活动院校及班级
     * @return  bool
    */
    public static function bindClassroom (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomBindCmd $classroomBindCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindClassroom($classroomBindCmd);
    }

    /**
     * 获取用户毕业季活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ParticipationInfoDTO
    */
    public static function getParticipationInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getParticipationInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ParticipationInfoDTO"
        );
    }

    /**
     * 毕业季活动打卡
     * @return  int
    */
    public static function punchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchInCmd $punchInCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->punchIn($punchInCmd);
    }

    /**
     * 更新打卡内容状态
     * @return  bool
    */
    public static function updateRecordStatus (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\UpdateRecordStatusCmd $updateRecordStatusCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateRecordStatus($updateRecordStatusCmd);
    }

    /**
     * 获取我的毕业相册
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\MyGraduationAlbumDTO
    */
    public static function getMyGraduationAlbum () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyGraduationAlbum(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\MyGraduationAlbumDTO"
        );
    }

    /**
     * 获取我的毕业瞬间列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO
    */
    public static function getMyGraduationMomentList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\MyGraduationMomentListCmd $myGraduationMomentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyGraduationMomentList($myGraduationMomentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO"
        );
    }

    /**
     * 获取打卡内容列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO
    */
    public static function getPunchRecordList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordListCmd $punchRecordListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPunchRecordList($punchRecordListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO"
        );
    }

    /**
     * 获取单条打卡内容详情
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListItemDTO
    */
    public static function getPunchRecordDetail (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordDetailCmd $punchRecordDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPunchRecordDetail($punchRecordDetailCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListItemDTO"
        );
    }

    /**
     * 获取班级详情信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomDetailDTO
    */
    public static function getClassroomDetail (int $classroomId, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getClassroomDetail(array_merge($_params, ["classroomId" => $classroomId])),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomDetailDTO"
        );
    }

    /**
     * 参与协助
     * @return  bool
    */
    public static function assistancePunch (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\AssistancePunchCmd $assistancePunchCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assistancePunch($assistancePunchCmd);
    }

    /**
     * 获取领取到的祝福语
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getReceivedGreetingList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReceivedGreetingList(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\GreetingInfoDTO[]"
        );
    }

    /**
     * 获取班级排名列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\TopClassroomListDTO
    */
    public static function getTopClassroomList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\TopClassroomListCmd $topClassroomListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTopClassroomList($topClassroomListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\TopClassroomListDTO"
        );
    }

    /**
     * 点赞记录
     * @return  int
    */
    public static function likePunchRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\LikePunchRecordCmd $likePunchRecordCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->likePunchRecord($likePunchRecordCmd);
    }

    /**
     * 根据班级id绑定班级
     * @return  bool
    */
    public static function bindClassroomById (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomBindByIdCmd $classroomBindByIdCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindClassroomById($classroomBindByIdCmd);
    }

    /**
     * 展示奖励信息
     * @return  array
    */
    public static function showAwardInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\AwardInfoCmd $awardInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->showAwardInfo($awardInfoCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\Coupon\DTO\FixedDateCouponShowDetailDTO[]"
        );
    }

    /**
     * 是否可以参与协助
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\AssistanceCheckResultDTO
    */
    public static function canAssistance (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\AssistanceCheckCmd $assistanceCheckCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->canAssistance($assistanceCheckCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\AssistanceCheckResultDTO"
        );
    }

    /**
     * 确认奖品信息
     * @return  bool
    */
    public static function confirmAwardInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\AwardInfoCmd $awardInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmAwardInfo($awardInfoCmd);
    }

    /**
     * 创建用户行为记录
     * @return  bool
    */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\UserBehaviorCreateCmd $userBehaviorCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehavior($userBehaviorCreateCmd);
    }

    /**
     * 用户是否已生成过毕业相册
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function isGraduationAlbumGenerated () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isGraduationAlbumGenerated();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}