<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-20 09:52:05
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\MessageBoard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MessageBoard
 * @method getMessageListByParams(array $params) 按条件查询用户留言列表
 * @method deleteMessageByParams(array $params) 删除一条用户留言
 * @method addStarByParams(array $params) 精选一条用户留言
 */
class MessageBoard {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\MessageBoard\\MessageBoard";

    /**
     * 按条件查询用户留言列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\DTO\MessageBoardListDTO
    */
    public static function getMessageList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\Cmd\MessageBoardSearchCMD $messageBoardSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMessageList($messageBoardSearchCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MessageBoard\DTO\MessageBoardListDTO"
        );
    }

    /**
     * 删除一条用户留言
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function deleteMessage (int $messageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMessage(array_merge($_params, ["messageId" => $messageId]));
    }

    /**
     * 精选一条用户留言
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addStar (int $messageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStar(array_merge($_params, ["messageId" => $messageId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}