<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-11 10:40:46
 */
namespace Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd;

class MomentCreateCmd {
    /**
     * @var  string
     * 品牌
     * validation: required|in:blue,gold
     */
    public string $brand;
    /**
     * @var  string
     * 朋友圈内容
     * validation: 
     */
    public string $content;
    /**
     * @var  array
     * 朋友圈内容素材
     * validation: required|wechat_work_material
     */
    public array $material;
    /**
     * @var  null|string
     * 发布时间
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public ?string $published_at = null;
    /**
     * @var  int[]
     * 朋友圈发布范围
     * validation: 
     */
    public array $store_ids;
    /**
     * @var  string
     * 朋友圈类型
     * validation: required|in:video,web_page,graphic
     */
    public string $type;

    public function __construct (int $currentManageStaffId = 0, string $brand = '', string $content = '', array $material = [], array $store_ids = [], string $type = '') {
        if (!is_null($currentManageStaffId)) {
            $this->currentManageStaffId = $currentManageStaffId;
        }
        if (!is_null($brand)) {
            $this->brand = $brand;
        }
        if (!is_null($content)) {
            $this->content = $content;
        }
        if (!is_null($material)) {
            $this->material = $material;
        }
        if (!is_null($store_ids)) {
            $this->store_ids = $store_ids;
        }
        if (!is_null($type)) {
            $this->type = $type;
        }
    }

    public static function create(int $currentManageStaffId = 0, string $brand = '', string $content = '', array $material = [], array $store_ids = [], string $type = ''): self {
        return new self($currentManageStaffId, $brand, $content, $material, $store_ids, $type);
    }

    public function setBrand(string $brand): self {
        $this->brand = $brand;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setMaterial(array $material): self {
        $this->material = $material;

        return $this;
    }

    public function setPublishedAt(?string $published_at): self {
        $this->published_at = $published_at;

        return $this;
    }

    public function setStoreIds(array $store_ids): self {
        $this->store_ids = $store_ids;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }
}