<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-11 10:40:46
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class FairyTaleTownActivityMessagePush
 * @method sendLiveStartNoticeToMQByParams(array $params) 直播开播提醒
 * @method sendProductReleaseNoticeToMQByParams(array $params) 产品上新通知
 * @method sendMemberActivityNoticeToMQByParams(array $params) 会员活动提醒
 * @method pushActivityMessageByParams(array $params) 推送活动消息
 * @method rePushActivityMessageByParams(array $params) 推送活动消息到MQ - Debug 工具
 */
class FairyTaleTownActivityMessagePush {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Cron\\FairyTaleTownActivityMessagePush";

    /**
     * 直播开播提醒
     * @return  bool
    */
    public static function sendLiveStartNoticeToMQ () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendLiveStartNoticeToMQ();
    }

    /**
     * 产品上新通知
     * @return  bool
    */
    public static function sendProductReleaseNoticeToMQ () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendProductReleaseNoticeToMQ();
    }

    /**
     * 会员活动提醒
     * @return  bool
    */
    public static function sendMemberActivityNoticeToMQ () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMemberActivityNoticeToMQ();
    }

    /**
     * 推送活动消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function pushActivityMessage (int $eventId, string $openId, string $event, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushActivityMessage(array_merge($_params, ["eventId" => $eventId, "openId" => $openId, "event" => $event]));
    }

    /**
     * 推送活动消息到MQ - Debug 工具
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function rePushActivityMessage (string $event, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rePushActivityMessage(array_merge($_params, ["event" => $event]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}