<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-25 16:56:49
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ActivityManage
 * @method listByParams(array $params) 获取活动列表
 * @method createActivityByParams(array $params) 创建活动
 * @method updateActivityByParams(array $params) 编辑活动
 * @method getActivityByParams(array $params) 获取指定的活动详情
 * @method getMiniProgramQrcodeByParams(array $params) 获取小程序二维码--废弃
 * @method getUnlimitedWxMiniCodeBase64ByParams(array $params) 获取小程序二维码Base64
 * @method getActivityMiniUrlLinkByParams(array $params) 获取活动小程序UrlLink
 * @method addProductBuyNumByParams(array $params) 增加活动产品库存-目前限拼团及限时购活动
 * @method getUnfinishedActivitiesByParams(array $params) 获取未结束的活动--bms使用
 * @method simpleListForRpcByParams(array $params) 获取活动基础信息列表
 * @method getLiveActivityAccountTreeByParams(array $params) 获取直播活动账号树结构
 * @method getFlashSaleCreatorListByParams(array $params) 获取限时购活动创建人列表
 */
class ActivityManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\ActivityManage";

    /**
     * 获取活动列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(array_merge($_params, ["page" => $page, "page_size" => $page_size]));
    }

    /**
     * 创建活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function createActivity (string $title, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createActivity(array_merge($_params, ["title" => $title]));
    }

    /**
     * 编辑活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function updateActivity (int $activity_id, string $title, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateActivity(array_merge($_params, ["activity_id" => $activity_id, "title" => $title]));
    }

    /**
     * 获取指定的活动详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getActivity (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 获取小程序二维码--废弃
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMiniProgramQrcode (string $path, string $appName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniProgramQrcode(array_merge($_params, ["path" => $path, "appName" => $appName]));
    }

    /**
     * 获取小程序二维码Base64
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\WxMiniCodeDTO
    */
    public static function getUnlimitedWxMiniCodeBase64 (\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\CMD\GetUnlimitedWxMiniCodeCMD $getUnlimitedWxMiniCodeCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUnlimitedWxMiniCodeBase64($getUnlimitedWxMiniCodeCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\WxMiniCodeDTO"
        );
    }

    /**
     * 获取活动小程序UrlLink
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getActivityMiniUrlLink (int $activity_id, string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityMiniUrlLink(array_merge($_params, ["activity_id" => $activity_id, "path" => $path]));
    }

    /**
     * 增加活动产品库存-目前限拼团及限时购活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addProductBuyNum (int $activity_id, int $product_category_id, int $num, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductBuyNum(array_merge($_params, ["activity_id" => $activity_id, "product_category_id" => $product_category_id, "num" => $num]));
    }

    /**
     * 获取未结束的活动--bms使用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUnfinishedActivities (array $types, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnfinishedActivities(array_merge($_params, ["types" => $types]));
    }

    /**
     * 获取活动基础信息列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\ActivitySimpleListDTO
    */
    public static function simpleListForRpc (\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\CMD\ActivityListCMD $activityListCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->simpleListForRpc($activityListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\ActivitySimpleListDTO"
        );
    }

    /**
     * 获取直播活动账号树结构
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getLiveActivityAccountTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLiveActivityAccountTree();
    }

    /**
     * 获取限时购活动创建人列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getFlashSaleCreatorList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFlashSaleCreatorList(array_merge($_params, []));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}