<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-22 09:31:38
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\GraduationGiftPackageActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GraduationGiftPackage
 * @method isReceivedByParams(array $params) 是否领取过毕业大礼包
 * @method isReceivedForRPCByParams(array $params) 是否领取过毕业大礼包 -- RPC调用
 * @method giftPackageCouponsByParams(array $params) 获取毕业季大礼包列表
 * @method receiveByParams(array $params) 领取毕业大礼包
 * @method syncSendGiftPackageByParams(array $params) 异步发放毕业大礼包
 */
class GraduationGiftPackage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\GraduationGiftPackageActivity\\GraduationGiftPackage";

    /**
     * 是否领取过毕业大礼包
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO
    */
    public static function isReceived (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\GraduationGiftPackageIsReceiveCmd $graduationGiftPackageIsReceiveCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isReceived($graduationGiftPackageIsReceiveCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO"
        );
    }

    /**
     * 是否领取过毕业大礼包 -- RPC调用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO
    */
    public static function isReceivedForRPC (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isReceivedForRPC(["userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageIsReceiveDTO"
        );
    }

    /**
     * 获取毕业季大礼包列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageCouponsDTO
    */
    public static function giftPackageCoupons () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->giftPackageCoupons(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\DTO\GraduationGiftPackageCouponsDTO"
        );
    }

    /**
     * 领取毕业大礼包
     * @return  bool
    */
    public static function receive (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\GraduationGiftPackageReceiveCmd $graduationGiftPackageReceiveCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receive($graduationGiftPackageReceiveCmd);
    }

    /**
     * 异步发放毕业大礼包
     * @return  bool
    */
    public static function syncSendGiftPackage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GraduationGiftPackageActivity\Cmd\SyncSendGiftPackageCmd $syncSendGiftPackageCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncSendGiftPackage($syncSendGiftPackageCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}