<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-11 16:33:07
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Activity
 * @method getActivityByParams(array $params) 获取单个活动详情
 * @method joinActivityByParams(array $params) 用户加入活动
 * @method getSponsorActivityInfoByParams(array $params) 获取活动发起者的活动信息
 * @method getInviteeActivityInfoByParams(array $params) 获取活动助力者的活动信息
 * @method canJoinByNeedConsumeByParams(array $params) 校验当前用户是否需要消费才能加入活动
 * @method canJoinByRegisteredFromByParams(array $params) 校验当前用户是否是当前活动品牌的新用户
 * @method canJoinByNeedNewUserByParams(array $params) 校验当前用户是否是当前活动品牌的新用户
 * @method canJoinByNewStudentMemberByParams(array $params) 校验当前用户是否能加入学生会员
 * @method joinGroupListByParams(array $params) 获取拼团列表
 * @method checkActivityInfoByParams(array $params) 检查活动信息--预约端调用
 * @method checkLimitedTimeBuyByParams(array $params) 检查限时购活动信息
 * @method checkActivityInfoForWebByParams(array $params) 检查活动信息--web
 * @method groupBuyOrderListByParams(array $params) 用户拼团订单列表
 * @method searchUserGroupBuySubmittedOrderByParams(array $params) 查找用户未支付的团购订单
 * @method findInvitedHistoryRecordsByParams(array $params) 查找用户的历史邀请记录
 * @method findInvitedRecordsByParams(array $params) 查找用户当前活动的邀请记录
 * @method discountProductCategoryListByParams(array $params) 获取活动折扣产品组列表
 * @method canReservationAnytimeByParams(array $params) 是否可以任意时间段内预约
 * @method checkProductParticipateStoreByParams(array $params) 检查产品是否参与限时购门店折扣
 * @method getStoreDiscountRulesByParams(array $params) 获取当前门店下的活动优惠规则--限时购活动使用
 * @method getShareUserMiniProgramQrcodeByParams(array $params) 获取发起人生成的小程序码
 * @method homepageByParams(array $params) 渲染会员小程序首页
 * @method canJoinByNeedVipLimitByParams(array $params) 校验当前用户是否满足会员等级限制
 */
class Activity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\Activity";

    /**
     * 获取单个活动详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getActivity (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 用户加入活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function joinActivity (int $activity_id,  $user_info, int $member_id = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinActivity(array_merge($_params, ["activity_id" => $activity_id, "user_info" => $user_info, "member_id" => $member_id]));
    }

    /**
     * 获取活动发起者的活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getSponsorActivityInfo (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSponsorActivityInfo(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 获取活动助力者的活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getInviteeActivityInfo (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInviteeActivityInfo(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 校验当前用户是否需要消费才能加入活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function canJoinByNeedConsume (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedConsume(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 校验当前用户是否是当前活动品牌的新用户
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function canJoinByRegisteredFrom (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByRegisteredFrom(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 校验当前用户是否是当前活动品牌的新用户
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function canJoinByNeedNewUser (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedNewUser(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 校验当前用户是否能加入学生会员
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function canJoinByNewStudentMember (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNewStudentMember(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 获取拼团列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function joinGroupList (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinGroupList(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 检查活动信息--预约端调用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkActivityInfo (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkActivityInfo(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 检查限时购活动信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkLimitedTimeBuy (int $activity_id, array $products_detail, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkLimitedTimeBuy(array_merge($_params, ["activity_id" => $activity_id, "products_detail" => $products_detail]));
    }

    /**
     * 检查活动信息--web
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkActivityInfoForWeb (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkActivityInfoForWeb(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 用户拼团订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function groupBuyOrderList (int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupBuyOrderList(array_merge($_params, ["page" => $page, "page_size" => $page_size]));
    }

    /**
     * 查找用户未支付的团购订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function searchUserGroupBuySubmittedOrder (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUserGroupBuySubmittedOrder(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 查找用户的历史邀请记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function findInvitedHistoryRecords (int $activity_id, int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findInvitedHistoryRecords(array_merge($_params, ["activity_id" => $activity_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 查找用户当前活动的邀请记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function findInvitedRecords (int $activity_id, int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findInvitedRecords(array_merge($_params, ["activity_id" => $activity_id, "page" => $page, "page_size" => $page_size]));
    }

    /**
     * 获取活动折扣产品组列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function discountProductCategoryList (int $activity_id, int $city_id = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->discountProductCategoryList(array_merge($_params, ["activity_id" => $activity_id, "city_id" => $city_id]));
    }

    /**
     * 是否可以任意时间段内预约
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function canReservationAnytime (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canReservationAnytime(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * 检查产品是否参与限时购门店折扣
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkProductParticipateStore (int $activity_id, array $products, int $store_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductParticipateStore(array_merge($_params, ["activity_id" => $activity_id, "products" => $products, "store_id" => $store_id]));
    }

    /**
     * 获取当前门店下的活动优惠规则--限时购活动使用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStoreDiscountRules (int $activity_id, int $store_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreDiscountRules(array_merge($_params, ["activity_id" => $activity_id, "store_id" => $store_id]));
    }

    /**
     * 获取发起人生成的小程序码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getShareUserMiniProgramQrcode (string $app_name, string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShareUserMiniProgramQrcode(array_merge($_params, ["app_name" => $app_name, "path" => $path]));
    }

    /**
     * 渲染会员小程序首页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function homepage (int $page = 1, int $page_size = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->homepage(array_merge($_params, ["page" => $page, "page_size" => $page_size]));
    }

    /**
     * 校验当前用户是否满足会员等级限制
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function canJoinByNeedVipLimit (int $activity_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedVipLimit(array_merge($_params, ["activity_id" => $activity_id]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}