<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-03 18:09:26
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ActivitySchool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ActivitySchool
 * @method getListByParams(array $params) 获取活动院校列表
 * @method getSchoolByParams(array $params) 获取单个院校信息
 */
class ActivitySchool {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\ActivitySchool\\ActivitySchool";

    /**
     * 获取活动院校列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\DTO\ActivitySchoolListDTO
    */
    public static function getList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\Cmd\ActivitySchoolListCmd $activitySchoolListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getList($activitySchoolListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\DTO\ActivitySchoolListDTO"
        );
    }

    /**
     * 获取单个院校信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\DTO\ActivitySchoolListItemDTO
    */
    public static function getSchool (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\Cmd\ActivitySchoolDetailCMD $activitySchoolDetailCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSchool($activitySchoolDetailCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivitySchool\DTO\ActivitySchoolListItemDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}