<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-08 12:31:31
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\MarketingRule;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MarketingRuleManage
 * @method listByParams(array $params) 营销规则列表
 * @method createByParams(array $params) 创建营销规则
 * @method detailByParams(array $params) 获取营销规则详情
 * @method deleteByParams(array $params) 删除单个营销规则
 * @method updateStatusByParams(array $params) 更新营销规则状态
 * @method updateByParams(array $params) 更新营销规则
 * @method simpleListByParams(array $params) 营销规则简要信息列表
 */
class MarketingRuleManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\MarketingRule\\MarketingRuleManage";

    /**
     * 营销规则列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\MarketingRuleListCMD $marketingRuleListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($marketingRuleListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleListDTO"
        );
    }

    /**
     * 创建营销规则
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\CreateMarketingRuleCMD $createMarketingRuleCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createMarketingRuleCMD);
    }

    /**
     * 获取营销规则详情
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleDetailDTO
    */
    public static function detail (\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\MarketingRuleDetailCMD $marketingRuleDetailCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail($marketingRuleDetailCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleDetailDTO"
        );
    }

    /**
     * 删除单个营销规则
     * @return  bool
    */
    public static function delete (\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\DeleteMarketingRuleCMD $deleteMarketingRuleCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete($deleteMarketingRuleCMD);
    }

    /**
     * 更新营销规则状态
     * @return  bool
    */
    public static function updateStatus (\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\UpdateMarketingRuleStatusCMD $updateMarketingRuleStatusCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus($updateMarketingRuleStatusCMD);
    }

    /**
     * 更新营销规则
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\UpdateMarketingRuleCMD $updateMarketingRuleCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($updateMarketingRuleCMD);
    }

    /**
     * 营销规则简要信息列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleSimpleListDTO
    */
    public static function simpleList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\CMD\MarketingRuleSimpleListCMD $marketingRuleSimpleListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->simpleList($marketingRuleSimpleListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MarketingRule\DTO\MarketingRuleSimpleListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}