<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-01 09:22:21
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class LotteryActivity
 * @method getParticipateDetailByParams(array $params) 获取抽奖活动参与信息
 * @method checkUserBeforeJoinByParams(array $params) 加入抽奖活动前校验用户
 * @method getLotteryWinnerListByParams(array $params) 获取中奖用户列表--分页
 * @method getUserUnsharedOrderNumByParams(array $params) 获取用户未完成分享秀的订单号(from cache)
 * @method getActivityMemberDetailByParams(array $params) 获取活动参与用户详情
 */
class LotteryActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\LotteryActivity";

    /**
     * 获取抽奖活动参与信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getParticipateDetail (int $activityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParticipateDetail(["activityId" => $activityId]);
    }

    /**
     * 加入抽奖活动前校验用户
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkUserBeforeJoin (int $activityId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserBeforeJoin(array_merge($_params, ["activityId" => $activityId]));
    }

    /**
     * 获取中奖用户列表--分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLotteryWinnerList (int $activityId, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLotteryWinnerList(["activityId" => $activityId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取用户未完成分享秀的订单号(from cache)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getUserUnsharedOrderNum () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserUnsharedOrderNum();
    }

    /**
     * 获取活动参与用户详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getActivityMemberDetail (int $activityId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityMemberDetail(array_merge($_params, ["activityId" => $activityId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}