<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-07 14:45:02
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class BestieActivity
 * @method getActivityInfoByParams(array $params) 获取闺蜜认证活动信息
 * @method canInitiateCertificationByParams(array $params) 校验发起人是否能发起活动
 * @method initiateCertificationByParams(array $params) 发起人发起认证
 * @method getCertificationSuccessListByParams(array $params) 获取认证成功列表
 * @method isSubscribedMessageByParams(array $params) 校验发起人是否已订阅消息
 * @method getSponsorInitiateInfoByParams(array $params) 获取发起人发起认证的信息
 * @method receiveNewUserWelfareByParams(array $params) 领取新人福利
 * @method participateCertificationByParams(array $params) 受邀人参与认证
 * @method getCertificationResultDetailByParams(array $params) 获取认证结果详情
 * @method getFirstCertificationSuccessInfoByParams(array $params) 获取首次认证成功信息
 * @method getUserBehaviorsByParams(array $params) 获取用户行为记录列表
 * @method createUserBehaviorByParams(array $params) 创建用户行为记录
 * @method canParticipateCertificationByParams(array $params) 校验受邀人能否参与当前发起人发起的认证
 */
class BestieActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\BestieActivity";

    /**
     * 获取闺蜜认证活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function canInitiateCertification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canInitiateCertification();
    }

    /**
     * 发起人发起认证
     * @return  int
    */
    public static function initiateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\InitiateCertificationCmd $initiateCertificationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->initiateCertification($initiateCertificationCmd);
    }

    /**
     * 获取认证成功列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationSuccessListDTO
    */
    public static function getCertificationSuccessList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationSuccessListCmd $certificationSuccessListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCertificationSuccessList($certificationSuccessListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationSuccessListDTO"
        );
    }

    /**
     * 校验发起人是否已订阅消息
     * @return  bool
    */
    public static function isSubscribedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isSubscribedMessage($subscribedMessageCheckCmd);
    }

    /**
     * 获取发起人发起认证的信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\SponsorInitiateInfoDTO
    */
    public static function getSponsorInitiateInfo (int $recordId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSponsorInitiateInfo(["recordId" => $recordId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\SponsorInitiateInfoDTO"
        );
    }

    /**
     * 领取新人福利
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ReceiveNewUserCouponResultDTO
    */
    public static function receiveNewUserWelfare (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ReceiveNewUserWelfareCmd $receiveNewUserWelfareCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->receiveNewUserWelfare($receiveNewUserWelfareCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ReceiveNewUserCouponResultDTO"
        );
    }

    /**
     * 受邀人参与认证
     * @return  int
    */
    public static function participateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCmd $participateCertificationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->participateCertification($participateCertificationCmd);
    }

    /**
     * 获取认证结果详情
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationResultDetailDTO
    */
    public static function getCertificationResultDetail (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationResultDetailCmd $certificationResultDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCertificationResultDetail($certificationResultDetailCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationResultDetailDTO"
        );
    }

    /**
     * 获取首次认证成功信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\FirstCertificationSuccessInfoDTO
    */
    public static function getFirstCertificationSuccessInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getFirstCertificationSuccessInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\FirstCertificationSuccessInfoDTO"
        );
    }

    /**
     * 获取用户行为记录列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\UserBehaviorMapDTO
    */
    public static function getUserBehaviors () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\UserBehaviorMapDTO"
        );
    }

    /**
     * 创建用户行为记录
     * @return  bool
    */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CreateUserBehaviorCmd $createUserBehaviorCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehavior($createUserBehaviorCmd);
    }

    /**
     * 校验受邀人能否参与当前发起人发起的认证
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ParticipateCheckResultDTO
    */
    public static function canParticipateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCheckCmd $participateCertificationCheckCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->canParticipateCertification($participateCertificationCheckCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ParticipateCheckResultDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}