<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-09 10:18:16
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MemberCardManage
 * @method listByParams(array $params) 获取会员卡列表--分页
 * @method detailByParams(array $params) 获取会员卡详情
 * @method bulkOpenByParams(array $params) 批量开启会员卡
 * @method bulkForbiddenByParams(array $params) 批量禁用会员卡
 */
class MemberCardManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\MemberCardManage";

    /**
     * 获取会员卡列表--分页
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\DTO\MemberCardListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\Cmd\MemberCardListCmd $memberCardListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($memberCardListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\DTO\MemberCardListDTO"
        );
    }

    /**
     * 获取会员卡详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\DTO\MemberCardDetailDTO
    */
    public static function detail (int $card_id, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(array_merge($_params, ["card_id" => $card_id])),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\DTO\MemberCardDetailDTO"
        );
    }

    /**
     * 批量开启会员卡
     * @return  bool
    */
    public static function bulkOpen (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationalCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkOpen($memberCardOperationalCmd);
    }

    /**
     * 批量禁用会员卡
     * @return  bool
    */
    public static function bulkForbidden (\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationalCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkForbidden($memberCardOperationalCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}