<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method addByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\Cmd\SmsTemplateAddCmd $params)
 * @method deleteByParams(array $params)
 */
class Template {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取模版列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\DTO\SmsTemplateListDTO
     */
    public static function list (int $page = 1, int $page_size = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                            "page" => $page,
                            "page_size" => $page_size,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\DTO\SmsTemplateListDTO"
        );
    }

    /**
     * 新增模版
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\Cmd\SmsTemplateAddCmd $smsTemplateAddCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\DTO\SmsTemplateDetailDTO
     */
    public static function add (\Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\Cmd\SmsTemplateAddCmd $smsTemplateAddCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->add($smsTemplateAddCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\SmsTemplate\DTO\SmsTemplateDetailDTO"
        );
    }


    /**
     * 删除模版
     *
     * @param  int $template_id 模版id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $template_id) {
        return self::getClass()->delete([
            "template_id" => $template_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Push\Template');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Push\Template');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}