<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-14 15:43:45
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MomentManage
 * @method listByParams(array $params) 获取企业微信朋友圈列表
 * @method getMomentByParams(array $params) 获取单条企业微信朋友圈
 * @method deleteMomentByParams(array $params) 删除企业微信朋友圈
 * @method updateMomentByParams(array $params) 编辑企业微信朋友圈
 * @method createMomentByParams(array $params) 创建企业微信朋友圈
 * @method getMomentSettingByParams(array $params) 获取朋友圈页面设置
 * @method saveMomentSettingByParams(array $params) 保存朋友圈页面设置
 */
class MomentManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "WechatWork\\MomentManage";

    /**
     * 获取企业微信朋友圈列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($momentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO"
        );
    }

    /**
     * 获取单条企业微信朋友圈
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
    */
    public static function getMoment (int $id, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMoment(array_merge($_params, ["id" => $id])),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }

    /**
     * 删除企业微信朋友圈
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function deleteMoment (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMoment(array_merge($_params, ["id" => $id]));
    }

    /**
     * 编辑企业微信朋友圈
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
    */
    public static function updateMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentUpdateCmd $momentUpdateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateMoment($momentUpdateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }

    /**
     * 创建企业微信朋友圈
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
    */
    public static function createMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentCreateCmd $momentCreateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createMoment($momentCreateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }

    /**
     * 获取朋友圈页面设置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMomentSetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMomentSetting();
    }

    /**
     * 保存朋友圈页面设置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function saveMomentSetting (array $page_setting, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveMomentSetting(array_merge($_params, ["page_setting" => $page_setting]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}