<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-01-07 15:01:23
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MilestoneWelfare
 * @method getMilestoneWelfareByUserIdByParams(array $params) 根据用户积分获取最近的里程碑福利
 * @method getMilestoneWelfareListByParams(array $params) 获取里程碑福利
 * @method exchangeByParams(array $params) 里程碑福利兑换
 * @method getStoresByRetailSkuIdByParams(array $params) 根据零售sku_id获取门店信息
 * @method getExchangedRetailInfoByParams(array $params) 零售提货页信息
 */
class MilestoneWelfare {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Milestone\\MilestoneWelfare";

    /**
     * 根据用户积分获取最近的里程碑福利
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMilestoneWelfareByUserId (int $quantity = 2, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMilestoneWelfareByUserId(array_merge($_params, ["quantity" => $quantity]));
    }

    /**
     * 获取里程碑福利
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMilestoneWelfareList (string $state = 'up', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMilestoneWelfareList(array_merge($_params, ["state" => $state]));
    }

    /**
     * 里程碑福利兑换
     * @return  bool
    */
    public static function exchange (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\Cmd\WelfareExchangeCmd $welfareExchangeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exchange($welfareExchangeCmd);
    }

    /**
     * 根据零售sku_id获取门店信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStoresByRetailSkuId (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoresByRetailSkuId(["skuId" => $skuId]);
    }

    /**
     * 零售提货页信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getExchangedRetailInfo (int $welfareId, string $orderNo, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExchangedRetailInfo(array_merge($_params, ["welfareId" => $welfareId, "orderNo" => $orderNo]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}