<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-01-07 15:01:23
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class JumpGameActivityMessagePush
 * @method sendMemberActivityNoticeToMQByParams(array $params) 会员活动提醒。活动期间每天12点
 * @method sendProductReleaseNoticeToMQByParams(array $params) 产品上新通知
 * @method handleSendPushMessageByParams(array $params) 推送活动事件通知消息
 * @method handleSendPushMessageToUserByParams(array $params) 推送活动事件消息通知到人
 */
class JumpGameActivityMessagePush {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Cron\\JumpGameActivityMessagePush";

    /**
     * 会员活动提醒。活动期间每天12点
     * @return  bool
    */
    public static function sendMemberActivityNoticeToMQ () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendMemberActivityNoticeToMQ();
    }

    /**
     * 产品上新通知
     * @return  bool
    */
    public static function sendProductReleaseNoticeToMQ () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendProductReleaseNoticeToMQ();
    }

    /**
     * 推送活动事件通知消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleSendPushMessage (string $settingName, string $eventName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSendPushMessage(array_merge($_params, ["settingName" => $settingName, "eventName" => $eventName]));
    }

    /**
     * 推送活动事件消息通知到人
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function handleSendPushMessageToUser (int $eventId, string $openId, string $settingName, string $eventName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleSendPushMessageToUser(array_merge($_params, ["eventId" => $eventId, "openId" => $openId, "settingName" => $settingName, "eventName" => $eventName]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}