<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-15 15:46:08
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CourtActivity
 * @method getActivityInfoByParams(array $params) 获取告白季活动信息
 * @method canInitiateActivityByParams(array $params) 校验发起人是否能发起活动
 * @method canAcceptInvitationByParams(array $params) 校验受邀人是否可以与发起人绑定
 * @method acceptInvitationByParams(array $params) 受邀人接受发起人邀请
 * @method getBoundRelationInfoByParams(array $params) 获取当前用户的绑定信息
 * @method punchInByParams(array $params) 活动打卡
 * @method applyPunchInByParams(array $params) 活动补卡
 * @method getCalendarInfoByParams(array $params) 获取当前用户打卡信息
 * @method updateMomentStatusByParams(array $params) 更新朋友圈状态
 * @method getMomentListByParams(array $params) 获取朋友圈列表
 * @method likeMomentByParams(array $params) 点赞朋友圈
 * @method dislikeMomentByParams(array $params) 取消赞朋友圈
 * @method getMomentByPunchDateByParams(array $params) 根据打卡日期获取朋友圈信息
 * @method isFirstPunchedByParams(array $params) 是否首次已打卡
 * @method isExistsMomentsInSquareByParams(array $params) 是否有朋友圈在广场
 * @method getPunchInResultsByParams(array $params) 获取打卡结果展示
 * @method notifyBindSuccessByParams(array $params) 告白季用户绑定成功发送通知
 */
class CourtActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\CourtActivity";

    /**
     * 获取告白季活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function canInitiateActivity () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canInitiateActivity();
    }

    /**
     * 校验受邀人是否可以与发起人绑定
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO
    */
    public static function canAcceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $acceptInvitationCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->canAcceptInvitation($acceptInvitationCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO"
        );
    }

    /**
     * 受邀人接受发起人邀请
     * @return  bool
    */
    public static function acceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $acceptInvitationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->acceptInvitation($acceptInvitationCmd);
    }

    /**
     * 获取当前用户的绑定信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO
    */
    public static function getBoundRelationInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBoundRelationInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO"
        );
    }

    /**
     * 活动打卡
     * @return  array
    */
    public static function punchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $punchInCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->punchIn($punchInCmd);
    }

    /**
     * 活动补卡
     * @return  array
    */
    public static function applyPunchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $applyPunchInCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->applyPunchIn($applyPunchInCmd);
    }

    /**
     * 获取当前用户打卡信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO
    */
    public static function getCalendarInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCalendarInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO"
        );
    }

    /**
     * 更新朋友圈状态
     * @return  bool
    */
    public static function updateMomentStatus (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\UpdateMomentStatusCmd $updateMomentStatusCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMomentStatus($updateMomentStatusCmd);
    }

    /**
     * 获取朋友圈列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentListDTO
    */
    public static function getMomentList (?\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\MomentListCmd $momentListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMomentList($momentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentListDTO"
        );
    }

    /**
     * 点赞朋友圈
     * @return  bool
    */
    public static function likeMoment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $likeMomentCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->likeMoment($likeMomentCmd);
    }

    /**
     * 取消赞朋友圈
     * @return  bool
    */
    public static function dislikeMoment (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\LikeMomentCmd $likeMomentCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dislikeMoment($likeMomentCmd);
    }

    /**
     * 根据打卡日期获取朋友圈信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentDetailDTO
    */
    public static function getMomentByPunchDate (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\GetMomentByPunchDateCmd $getMomentByPunchDateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMomentByPunchDate($getMomentByPunchDateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\MomentDetailDTO"
        );
    }

    /**
     * 是否首次已打卡
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function isFirstPunched () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isFirstPunched();
    }

    /**
     * 是否有朋友圈在广场
     * @return  bool
    */
    public static function isExistsMomentsInSquare () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isExistsMomentsInSquare();
    }

    /**
     * 获取打卡结果展示
     * @return  array
    */
    public static function getPunchInResults (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInResultCmd $punchInResultCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPunchInResults($punchInResultCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CouponShowDetailDTO[]"
        );
    }

    /**
     * 告白季用户绑定成功发送通知
     * @return  bool
    */
    public static function notifyBindSuccess (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\NotifyBindSuccessCmd $notifyBindSuccessCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notifyBindSuccess($notifyBindSuccessCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}