<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\GuestInformation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addGuestInformationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\GuestInformation\Cmd\AddGuestInformationCmd $params)
 */
class GuestInformation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增客资信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\GuestInformation\Cmd\AddGuestInformationCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addGuestInformation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\GuestInformation\Cmd\AddGuestInformationCmd $cmd) {
        return self::getClass()->addGuestInformation($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\GuestInformation\GuestInformation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\GuestInformation\GuestInformation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}