<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-10 10:41:02
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ActivityManage
 * @method listByParams(array $params) 获取活动列表
 * @method createActivityByParams(array $params) 创建活动
 * @method updateActivityByParams(array $params) 编辑活动
 * @method getActivityByParams(array $params) 获取指定的活动详情
 * @method getMiniProgramQrcodeByParams(array $params) 获取小程序二维码--废弃
 * @method getUnlimitedWxMiniCodeBase64ByParams(array $params) 获取小程序二维码Base64
 * @method getActivityMiniUrlLinkByParams(array $params) 获取活动小程序UrlLink
 * @method addProductBuyNumByParams(array $params) 增加活动产品库存-目前限拼团及限时购活动
 * @method getUnfinishedActivitiesByParams(array $params) 获取未结束的活动--bms使用
 * @method simpleListForRpcByParams(array $params) 获取活动基础信息列表
 */
class ActivityManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\ActivityManage";

    /**
     * 获取活动列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 创建活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function createActivity (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createActivity($_params);
    }
    /**
     * 编辑活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function updateActivity (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateActivity($_params);
    }
    /**
     * 获取指定的活动详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getActivity (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity($_params);
    }
    /**
     * 获取小程序二维码--废弃
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMiniProgramQrcode (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniProgramQrcode($_params);
    }
    /**
     * 获取小程序二维码Base64
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\WxMiniCodeDTO
    */
    public static function getUnlimitedWxMiniCodeBase64 (\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\CMD\GetUnlimitedWxMiniCodeCMD $getUnlimitedWxMiniCodeCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUnlimitedWxMiniCodeBase64($getUnlimitedWxMiniCodeCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\WxMiniCodeDTO"
        );
    }
    /**
     * 获取活动小程序UrlLink
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getActivityMiniUrlLink (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityMiniUrlLink($_params);
    }
    /**
     * 增加活动产品库存-目前限拼团及限时购活动
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addProductBuyNum (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductBuyNum($_params);
    }
    /**
     * 获取未结束的活动--bms使用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUnfinishedActivities (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnfinishedActivities($_params);
    }
    /**
     * 获取活动基础信息列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\ActivitySimpleListDTO
    */
    public static function simpleListForRpc (\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\CMD\ActivityListCMD $activityListCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->simpleListForRpc($activityListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Activity\DTO\ActivitySimpleListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}