<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-20 07:59:28
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Common
 */
class Common {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Common\\Common";

    /**
     * 获取领券活动页
     * @return  mixed
    */
    public static function getPreferentialPageActivityList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialPageActivityList($_params);
    }
    /**
     * 缦图产品列表
     * @return  mixed
    */
    public static function getMaintoProduct (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaintoProduct($_params);
    }
    /**
     * 根据筛选条件获取人数
     * @return  int
    */
    public static function getPeopleCount (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPeopleCount($_params);
    }
    /**
     * 上传图片
     * @return  mixed
    */
    public static function upLoadImage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upLoadImage($_params);
    }
    /**
     * 获取管理员信息
     * @return  array
    */
    public static function getManagerInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManagerInfo();
    }
    /**
     * 根据城市id获取门店企业微信信息
     * @return  mixed
    */
    public static function getStoreListByCityId (array $city_ids, array $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId(["city_ids" => $city_ids, "store_type" => $store_type]);
    }
    /**
     * 获取活动可用门店列表Ids
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getActivityAvailableStoreList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityAvailableStoreList($_params);
    }
    /**
     * 获取可参与活动的门店树
     * @return  array
    */
    public static function getAvailableStoreTree (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreTree($_params);
    }
    /**
     * 批量获取产品的折扣规则
     * @return  array
    */
    public static function getProductDiscountList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDiscountList($_params);
    }
    /**
     * 获取活动门店中距离最近的门店
     * @return  mixed
    */
    public static function getMostNearestStore (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStore($_params);
    }
    /**
     * 通过品牌获取最近的门店
     * @return  mixed
    */
    public static function getMostNearestStoreByBrand (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStoreByBrand($_params);
    }
    /**
     * 获取活动链接参数
     * @return  string
    */
    public static function getActivityLinkParameter (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityLinkParameter($_params);
    }
    /**
     * 保存活动链接参数
     * @return  int
    */
    public static function saveActivityLinkParameter (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveActivityLinkParameter($_params);
    }
    /**
     * 获取微信小程序UrlLink
     * @return  array
    */
    public static function getMiniUrlLink (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniUrlLink($_params);
    }
    /**
     * 获取二维码
     * @return  string
    */
    public static function getQrcode (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQrcode($_params);
    }
    /**
     * 根据产品id列表获取可用门店
     * @return  array
    */
    public static function getAvailableStoreIdsByProductIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreIdsByProductIds($_params);
    }
    /**
     * 获取产品组产品信息
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getCategoryProductInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductInfo($_params);
    }
    /**
     * 获取产品组详情
     * @return  array
    */
    public static function getCategoryDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryDetail($_params);
    }
    /**
     * 订阅小程序消息
     * @return  bool
    */
    public static function subscribeMessage (string $brand, array $messages) {
        return RpcClass::getClass(self::$serviceName, self::$className)->subscribeMessage(["brand" => $brand, "messages" => $messages]);
    }
    /**
     * 分页获取优惠券列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO
    */
    public static function getPreferentialTemplateList (\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\Cmd\PreferentialTemplateListCmd $preferentialTemplateListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialTemplateList($preferentialTemplateListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO"
        );
    }
    /**
     * 获取成片列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO
    */
    public static function getUserFinishPhotoList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\Cmd\UserFinishPhotoListCmd $userFinishPhotoListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserFinishPhotoList($userFinishPhotoListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO"
        );
    }
    /**
     * 图片内容审核
     * @return  bool
    */
    public static function imageCensor (\Mainto\Bridge\Structs\ProjectCrm\Common\ImageCensor\Cmd\GreenImageCheckCmd $greenImageCheckCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->imageCensor($greenImageCheckCmd);
    }
    /**
     * 是否已订阅过当前事件
     * @return  bool
    */
    public static function isSubscribedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SubscribeMessage\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isSubscribedMessage($subscribedMessageCheckCmd);
    }
    /**
     * 获取用户基础信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO
    */
    public static function getUserBaseInfo (\Mainto\Bridge\Structs\ProjectCrm\Common\User\Cmd\UserBaseInfoCmd $userBaseInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBaseInfo($userBaseInfoCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO"
        );
    }
    /**
     * 获取服务器当前时间戳
     * @return  string
    */
    public static function getCurrentServerTimestamp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentServerTimestamp();
    }
    /**
     * 转换内容为base64
     * @return  string
    */
    public static function convertToBase64 (string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->convertToBase64(["content" => $content]);
    }
    /**
     * 获取省份列表
     * @return  array
    */
    public static function getProvinceList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProvinceList(),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\Area\DTO\ProvinceInfoDTO[]"
        );
    }
    /**
     * 创建一个计数器
     * @return  bool
    */
    public static function createCounter (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\CreateCounterCMD $createCounterCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createCounter($createCounterCMD);
    }
    /**
     * 设置计数器剩余
     * @return  bool
    */
    public static function setCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\SetCounterRemainingCMD $setCounterRemainingCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCounterRemaining($setCounterRemainingCMD);
    }
    /**
     * 获取计数器剩余
     * @return  int
    */
    public static function getCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\GetCounterRemainingCMD $getCounterRemainingCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCounterRemaining($getCounterRemainingCMD);
    }
    /**
     * 创建用户行为记录
     * @return  bool
    */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\CreateUserBehaviorCMD $createUserBehaviorCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehavior($createUserBehaviorCMD);
    }
    /**
     * 用户行为是否存在
     * @return  bool
    */
    public static function isUserBehaviorExists (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\BehaviorExistsCheckCMD $behaviorExistsCheckCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isUserBehaviorExists($behaviorExistsCheckCMD);
    }
    /**
     * 用户风控查询
     * @return  bool
    */
    public static function isRiskUser () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isRiskUser();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}