<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-06 11:42:38
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SpreadPlan
 */
class SpreadPlan {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Push\\SpreadPlan";

    /**
     * 创建推广计划
     * @return  bool
    */
    public static function createSpreadPlan (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpreadPlan($_params);
    }
    /**
     * 编辑推广计划
     * @return  bool
    */
    public static function editSpreadPlan (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSpreadPlan($_params);
    }
    /**
     * 推广计划取消
     * @return  bool
    */
    public static function cancelSpreadPlan (int $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelSpreadPlan(["task_id" => $task_id]);
    }
    /**
     * 删除推广计划
     * @return  bool
    */
    public static function deleteSpreadPlan (int $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSpreadPlan(["task_id" => $task_id]);
    }
    /**
     * 推广计划详情
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO
    */
    public static function spreadPlanDetail (int $task_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanDetail(["task_id" => $task_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO"
        );
    }
    /**
     * 推广计划列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO
    */
    public static function spreadPlanList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\Cmd\PushTaskListCmd $pushTaskListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanList($pushTaskListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}