<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-14 14:11:05
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ActivityPage
 */
class ActivityPage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Manage\\ActivityPage";

    /**
     * 创建一个活动
     * @return  bool
    */
    public static function createActive (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createActive($_params);
    }
    /**
     * 活动查询
     * @return  array
    */
    public static function searchActive (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchActive($_params);
    }
    /**
     * 复制单个活动
     * @return  mixed
    */
    public static function copyActivityPageById (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyActivityPageById($_params);
    }
    /**
     * 单个活动查询
     * @return  mixed
    */
    public static function searchById (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchById(["_id" => $_id]);
    }
    /**
     * 更新活动
     * @return  bool
    */
    public static function update (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($_params);
    }
    /**
     * 删除活动
     * @return  bool
    */
    public static function delete (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["_id" => $_id]);
    }
    /**
     * 上线或下线活动
     * @return  bool
    */
    public static function upDownActivePage (string $_id, string $page_state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upDownActivePage(["_id" => $_id, "page_state" => $page_state]);
    }
    /**
     * 创建活动人群包
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\ActivityPeopleGroupPackDTO
    */
    public static function createPeoplePack (string $file_url) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createPeoplePack(["file_url" => $file_url]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\ActivityPeopleGroupPackDTO"
        );
    }
    /**
     * 创建画像平台活动人群包
     * @return  int
    */
    public static function createDmpServicePeoplePack (\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\CMD\CreateDmpServicePeoplePackCMD $createDmpServicePeoplePackCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDmpServicePeoplePack($createDmpServicePeoplePackCMD);
    }
    /**
     * 获取画像平台人群包信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpServicePeoplePackInfoDTO
    */
    public static function getDmpServicePeoplePackInfo (int $peoplePackId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDmpServicePeoplePackInfo(["peoplePackId" => $peoplePackId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpServicePeoplePackInfoDTO"
        );
    }
    /**
     * 获取画像平台人群包
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpGroupListDTO
    */
    public static function getDmpGroupList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\CMD\DmpGroupListCMD $dmpGroupListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDmpGroupList($dmpGroupListCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\ActivityPage\DTO\DmpGroupListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}