<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-03 16:43:42
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Permission
 */
class Permission {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Auth\\Permission";

    /**
     * 获取所有权限列表
     * @return  array
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionDetailDTO[]"
        );
    }
    /**
     * 创建权限
     * @return  int
    */
    public static function add (\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\Cmd\PermissionCreateCmd $permissionCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add($permissionCreateCmd);
    }
    /**
     * 删除权限
     * @return  bool
    */
    public static function delete (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete($_params);
    }
    /**
     * 根据权限获取拥有该权限的所有员工
     * @return  array
    */
    public static function getStaffsByPermission (int $permission_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffsByPermission(["permission_id" => $permission_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionStaffInfoDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}