<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-18 09:33:02
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RedEnvelopeActivity
 */
class RedEnvelopeActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\RedEnvelopeActivity";

    /**
     * 获取用户行为记录列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO
    */
    public static function getUserBehaviors () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }
    /**
     * 通过userId获取用户行为记录列表
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO
    */
    public static function getUserBehaviorsByUserId (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviorsByUserId(["userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }
    /**
     * 创建用户行为记录
     * @return  bool
    */
    public static function createUserBehaviorRecord (string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecord(["behavior" => $behavior]);
    }
    /**
     * 通过userId创建用户行为记录
     * @return  bool
    */
    public static function createUserBehaviorRecordByUserId (int $userId, string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecordByUserId(["userId" => $userId, "behavior" => $behavior]);
    }
    /**
     * 通过behavior获取对应的userId列表--预约端调用
     * @return  array
    */
    public static function getUserIdsByBehavior (string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByBehavior(["behavior" => $behavior]);
    }
    /**
     * 获取新年活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO"
        );
    }
    /**
     * 获取红包活动分享海报二维码
     * @return  string
    */
    public static function getPosterQrcode (int $greetingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPosterQrcode(["greetingId" => $greetingId]);
    }
    /**
     * 获取红包金额明细
     * @return  array
    */
    public static function getRedEnvelopeAmountDetails () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRedEnvelopeAmountDetails();
    }
    /**
     * 用户参与详情
     * @return  array
    */
    public static function getParticipationDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParticipationDetail();
    }
    /**
     * 获取用户惊喜红包详情
     * @return  array
    */
    public static function getAssistanceRedEnvelopeDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssistanceRedEnvelopeDetail();
    }
    /**
     * 开红包
     * @return  array
    */
    public static function openRedEnvelope (string $type, int $fromUser, int $greetingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->openRedEnvelope(["type" => $type, "fromUser" => $fromUser, "greetingId" => $greetingId]);
    }
    /**
     * 根据id获取用户脱敏详情
     * @return  array
    */
    public static function getUserInfoByUserId (int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoByUserId(["userId" => $userId]);
    }
    /**
     * 重置用户行为记录
     * @return  bool
    */
    public static function resetUserBehaviorRecord (string $behavior) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetUserBehaviorRecord(["behavior" => $behavior]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}