<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-17 17:38:10
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MilestoneWelfare
 */
class MilestoneWelfare {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Milestone\\MilestoneWelfare";

    /**
     * 根据用户积分获取最近的里程碑福利
     * @return  array
    */
    public static function getMilestoneWelfareByUserId (int $quantity = 2) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMilestoneWelfareByUserId(["quantity" => $quantity]);
    }
    /**
     * 获取里程碑福利
     * @return  array
    */
    public static function getMilestoneWelfareList (int $milestoneId, array $sortBy, string $state = 'up') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMilestoneWelfareList(["milestoneId" => $milestoneId, "sortBy" => $sortBy, "state" => $state]);
    }
    /**
     * 里程碑福利兑换
     * @return  bool
    */
    public static function exchange (int $welfareId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exchange(["welfareId" => $welfareId]);
    }
    /**
     * 根据零售sku_id获取门店信息
     * @return  array
    */
    public static function getStoresByRetailSkuId (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoresByRetailSkuId(["skuId" => $skuId]);
    }
    /**
     * 零售提货页信息
     * @return  array
    */
    public static function getExchangedRetailInfo (int $welfareId, string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExchangedRetailInfo(["welfareId" => $welfareId, "orderNo" => $orderNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}