<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-31 15:57:30
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MemberProperty
 */
class MemberProperty {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\MemberProperty";

    /**
     * 按品牌获取优惠券列表
     * @return  mixed
    */
    public static function getCouponList (int $user_id, string $brand, string $status, int $page = 1, int $page_size = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponList(["user_id" => $user_id, "brand" => $brand, "status" => $status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 按品牌获取产品卡列表
     * @return  mixed
    */
    public static function getProductCardList (int $user_id, string $brand, string $status, int $page = 1, int $page_size = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardList(["user_id" => $user_id, "brand" => $brand, "status" => $status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 按品牌获取礼品卡列表
     * @return  mixed
    */
    public static function getGiftCardList (int $user_id, string $brand, string $status, int $page = 1, int $page_size = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardList(["user_id" => $user_id, "brand" => $brand, "status" => $status, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取用户流水
     * @return  array
    */
    public static function getFlowList (int $user_id, array $types, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFlowList(["user_id" => $user_id, "types" => $types, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取资产汇总信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\MemberProperty\DTO\PropertySummaryInfoDTO
    */
    public static function allProperty (int $user_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allProperty(["user_id" => $user_id]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\MemberProperty\DTO\PropertySummaryInfoDTO"
        );
    }
    /**
     * 获取礼品卡使用明细
     * @return  array
    */
    public static function searchGiftCardDetails (int $gift_card_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchGiftCardDetails(["gift_card_id" => $gift_card_id, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取勋章明细
     * @return  array
    */
    public static function getMedalList (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMedalList(["user_id" => $user_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}