<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\HarryPotterActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method openCardByParams(array $params)
 * @method createInviteCardByParams(array $params)
 * @method answerQuestionByParams(array $params)
 * @method confirmCommandByParams(array $params)
 */
class HarryPotterActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 用户开卡
     *
     * @throws  \Exception
     * @return  array
     */
    public static function openCard () {
        return self::getClass()->openCard();
    }

    /**
     * 生成活动邀请函
     *
     * @support  string $nickname 用户昵称 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createInviteCard () {
        return self::getClass()->createInviteCard([
        ]);
    }

    /**
     * 回答问题
     *
     * @support  int $answerId 答案ID [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO
     */
    public static function answerQuestion () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->answerQuestion([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO"
        );
    }

    /**
     * 提交口令
     *
     * @support  string $command 口令 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO
     */
    public static function confirmCommand () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->confirmCommand([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\HarryPotterActivity\HarryPotterActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\HarryPotterActivity\HarryPotterActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}