<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\HarryPotterActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method openCardByParams(array $params)
 * @method agreeAskForCardByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $params)
 * @method receiveGiftCardByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $params)
 * @method createShareRecordByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\CreateShareRecordCMD $params)
 * @method getShareRecordByParams(array $params)
 * @method createInviteCardByParams(array $params)
 * @method answerQuestionByParams(array $params)
 * @method confirmCommandByParams(array $params)
 */
class HarryPotterActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 用户开卡
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CardTemplateDTO
     */
    public static function openCard () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->openCard(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CardTemplateDTO"
        );
    }

    /**
     * 用户同意索要卡片
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function agreeAskForCard (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $cmd) {
        return self::getClass()->agreeAskForCard($cmd);
    }


    /**
     * 用户领取赠送的卡片
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveGiftCard (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\ShareCardCMD $cmd) {
        return self::getClass()->receiveGiftCard($cmd);
    }


    /**
     * 创建分享记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\CreateShareRecordCMD $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function createShareRecord (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\CreateShareRecordCMD $cmd) {
        return self::getClass()->createShareRecord($cmd);
    }


    /**
     * 获取分享记录详情
     *
     * @support  int $recordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ShareRecordDetailDTO
     */
    public static function getShareRecord () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareRecord([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\ShareRecordDetailDTO"
        );
    }

    /**
     * 生成活动邀请函
     *
     * @support  string $nickname 用户昵称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createInviteCard () {
        return self::getClass()->createInviteCard([
        ]);
    }

    /**
     * 回答问题
     *
     * @support  int $answerId 答案ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO
     */
    public static function answerQuestion () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->answerQuestion([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\AnswerQuestionDTO"
        );
    }

    /**
     * 提交口令
     *
     * @support  string $command 口令 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO
     */
    public static function confirmCommand () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->confirmCommand([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\DTO\CommandDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\HarryPotterActivity\HarryPotterActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\HarryPotterActivity\HarryPotterActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}