<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method canInitiateCertificationByParams(array $params)
 * @method initiateCertificationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\InitiateCertificationCmd $params)
 * @method getCertificationSuccessListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationSuccessListCmd $params)
 * @method isSubscribedMessageByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SubscribedMessageCheckCmd $params)
 * @method getSponsorInitiateInfoByParams(array $params)
 * @method receiveNewUserWelfareByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ReceiveNewUserWelfareCmd $params)
 * @method participateCertificationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCmd $params)
 * @method getCertificationResultDetailByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationResultDetailCmd $params)
 * @method getFirstCertificationSuccessInfoByParams(array $params)
 * @method getUserBehaviorsByParams(array $params)
 * @method createUserBehaviorByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CreateUserBehaviorCmd $params)
 * @method canParticipateCertificationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCheckCmd $params)
 */
class BestieActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取闺蜜认证活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function canInitiateCertification () {
        return self::getClass()->canInitiateCertification();
    }

    /**
     * 发起人发起认证
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\InitiateCertificationCmd $initiateCertificationCmd
     * @throws  \Exception
     * @return  int
     */
    public static function initiateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\InitiateCertificationCmd $initiateCertificationCmd) {
        return self::getClass()->initiateCertification($initiateCertificationCmd);
    }


    /**
     * 获取认证成功列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationSuccessListCmd $certificationSuccessListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationSuccessListDTO
     */
    public static function getCertificationSuccessList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationSuccessListCmd $certificationSuccessListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCertificationSuccessList($certificationSuccessListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationSuccessListDTO"
        );
    }


    /**
     * 校验发起人是否已订阅消息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function isSubscribedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd) {
        return self::getClass()->isSubscribedMessage($subscribedMessageCheckCmd);
    }


    /**
     * 获取发起人发起认证的信息
     *
     * @param  int $recordId 发起人发起记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\SponsorInitiateInfoDTO
     */
    public static function getSponsorInitiateInfo (int $recordId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSponsorInitiateInfo([
                            "recordId" => $recordId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\SponsorInitiateInfoDTO"
        );
    }

    /**
     * 领取新人福利
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ReceiveNewUserWelfareCmd $receiveNewUserWelfareCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ReceiveNewUserCouponResultDTO
     */
    public static function receiveNewUserWelfare (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ReceiveNewUserWelfareCmd $receiveNewUserWelfareCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->receiveNewUserWelfare($receiveNewUserWelfareCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ReceiveNewUserCouponResultDTO"
        );
    }


    /**
     * 受邀人参与认证
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCmd $participateCertificationCmd
     * @throws  \Exception
     * @return  int
     */
    public static function participateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCmd $participateCertificationCmd) {
        return self::getClass()->participateCertification($participateCertificationCmd);
    }


    /**
     * 获取认证结果详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationResultDetailCmd $certificationResultDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationResultDetailDTO
     */
    public static function getCertificationResultDetail (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CertificationResultDetailCmd $certificationResultDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCertificationResultDetail($certificationResultDetailCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\CertificationResultDetailDTO"
        );
    }


    /**
     * 获取首次认证成功信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\FirstCertificationSuccessInfoDTO
     */
    public static function getFirstCertificationSuccessInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getFirstCertificationSuccessInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\FirstCertificationSuccessInfoDTO"
        );
    }

    /**
     * 获取用户行为记录列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\UserBehaviorMapDTO
     */
    public static function getUserBehaviors () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\UserBehaviorMapDTO"
        );
    }

    /**
     * 创建用户行为记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CreateUserBehaviorCmd $createUserBehaviorCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\CreateUserBehaviorCmd $createUserBehaviorCmd) {
        return self::getClass()->createUserBehavior($createUserBehaviorCmd);
    }


    /**
     * 校验受邀人能否参与当前发起人发起的认证
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCheckCmd $checkCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ParticipateCheckResultDTO
     */
    public static function canParticipateCertification (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\ParticipateCertificationCheckCmd $checkCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->canParticipateCertification($checkCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ParticipateCheckResultDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\BestieActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\BestieActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}