<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pushActivityStartNotifyByParams(array $params)
 * @method handleOpenRedEnvelopeByParams(array $params)
 */
class RedEnvelopeActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 推送活动开始通知
     *
     * @param  array $items 订阅活动开始通知的用户行为数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pushActivityStartNotify (array $items) {
        return self::getClass()->pushActivityStartNotify([
            "items" => $items,
        ]);
    }

    /**
     * 开红包处理
     *
     * @support  string $type 红包类型 [ require false ]
     * @support  int $userId 用户id [ require true ]
     * @support  float $amount 红包金额 [ require true ]
     * @support  int $num 当前开红包金额的排队位置 [ require true ]
     * @support  int $greetingId 祝福语id [ require false ]
     * @support  int $fromUser 红包来源用户id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function handleOpenRedEnvelope () {
        return self::getClass()->handleOpenRedEnvelope([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\RedEnvelopeActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\RedEnvelopeActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}