<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-25 16:11:35
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ChristmasActivity
 */
class ChristmasActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\ChristmasActivity";

    /**
     * 获取用户信息
     * @return  array
    */
    public static function getUserInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo();
    }
    /**
     * 发放优惠券
     * @return  array
    */
    public static function pushCoupon (int $templateId, string $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushCoupon(["templateId" => $templateId, "userId" => $userId]);
    }
    /**
     * 创建小程序码
     * @return  array
    */
    public static function createMiniProgramQrcode (string $path) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createMiniProgramQrcode(["path" => $path]);
    }
    /**
     * 获取圣诞产品客户成片列表
     * @return  array
    */
    public static function getChristmasProductFinishPhotoList (string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChristmasProductFinishPhotoList(["brand" => $brand]);
    }
    /**
     * 推送消息通知
     * @return  bool
    */
    public static function pushMessageNotify (string $templateId, string $jumpUrl, int $peopleNum, string $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushMessageNotify(["templateId" => $templateId, "jumpUrl" => $jumpUrl, "peopleNum" => $peopleNum, "userId" => $userId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}