<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-20 17:49:05
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\BirthdayActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class BirthdayActivity
 */
class BirthdayActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\BirthdayActivity\\BirthdayActivity";

    /**
     * 获取生日空投活动信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ActivityInfoDTO
    */
    public static function getActivityInfo (int $activityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(["activityId" => $activityId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ActivityInfoDTO"
        );
    }
    /**
     * 加入活动
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO
    */
    public static function joinActivity (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\JoinActivityCMD $joinActivityCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->joinActivity($joinActivityCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO"
        );
    }
    /**
     * 提交祝福
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO
    */
    public static function submitBlessing (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\SubmitBlessingCMD $submitBlessingCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->submitBlessing($submitBlessingCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO"
        );
    }
    /**
     * 获取当前用户收到的祝福
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingListDTO
    */
    public static function getMyBlessings (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyBlessingsCMD $getMyBlessingsCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyBlessings($getMyBlessingsCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingListDTO"
        );
    }
    /**
     * 获取当前活动成员信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ParticipateInfoDTO
    */
    public static function getMyParticipateInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyParticipateInfoCMD $getMyParticipateInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMyParticipateInfo($getMyParticipateInfoCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ParticipateInfoDTO"
        );
    }
    /**
     * 随机当前活动下的祝福
     * @return  array
    */
    public static function getBlessingsByRandom (int $activityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBlessingsByRandom(["activityId" => $activityId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingInfoDTO[]"
        );
    }
    /**
     * 获取祝福排行榜
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\TopMembersInfoDTO
    */
    public static function getTopMembers (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetTopMembersCMD $getTopMembersCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTopMembers($getTopMembersCMD),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\TopMembersInfoDTO"
        );
    }
    /**
     * 更新生日照
     * @return  bool
    */
    public static function updateBirthdayPhoto (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\UpdateBirthdayPhotoCMD $updateBirthdayPhotoCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBirthdayPhoto($updateBirthdayPhotoCMD);
    }
    /**
     * 获取发起人基础信息
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\SimpleMemberInfoDTO
    */
    public static function getMemberBaseInfo (int $memberId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMemberBaseInfo(["memberId" => $memberId]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\SimpleMemberInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}