<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 18:00:16
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class LotteryActivity
 */
class LotteryActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\LotteryActivity";

    /**
     * 获取抽奖活动参与信息
     */
    public static function getParticipateDetail (int $activityId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParticipateDetail(["activityId" => $activityId, ]);
    }
    /**
     * 加入抽奖活动前校验用户
     */
    public static function checkUserBeforeJoin (int $activityId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserBeforeJoin(["activityId" => $activityId, ]);
    }
    /**
     * 获取中奖用户列表--分页
     */
    public static function getLotteryWinnerList (int $activityId, int $page = 1, int $pageSize = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLotteryWinnerList(["activityId" => $activityId, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取用户未完成分享秀的订单号(from cache)
     */
    public static function getUserUnsharedOrderNum (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserUnsharedOrderNum();
    }
    /**
     * 获取活动参与用户详情
     */
    public static function getActivityMemberDetail (int $activityId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityMemberDetail(["activityId" => $activityId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}