<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method pushCouponByParams(array $params)
 * @method createMiniProgramQrcodeByParams(array $params)
 * @method getChristmasProductFinishPhotoListByParams(array $params)
 * @method pushMessageNotifyByParams(array $params)
 */
class ChristmasActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 发放优惠券
     *
     * @support  int $templateId 模板ID [ require true ]
     * @support  string $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pushCoupon () {
        return self::getClass()->pushCoupon([
        ]);
    }

    /**
     * 创建小程序码
     *
     * @support  string $path 小程序路径 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createMiniProgramQrcode () {
        return self::getClass()->createMiniProgramQrcode([
        ]);
    }

    /**
     * 获取圣诞产品客户成片列表
     *
     * @support  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChristmasProductFinishPhotoList () {
        return self::getClass()->getChristmasProductFinishPhotoList([
        ]);
    }

    /**
     * 推送消息通知
     *
     * @support  string $templateId 消息模板ID [ require true ]
     * @support  string $jumpUrl 公众号模板消息跳转URL [ require true ]
     * @support  int $peopleNum 助力人数 [ require false ]
     * @support  string $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pushMessageNotify () {
        return self::getClass()->pushMessageNotify([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\ChristmasActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\ChristmasActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}