<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-21 10:32:51
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Activity
 */
class Activity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\Activity";

    /**
     * 获取单个活动详情
     */
    public static function getActivity (int $activity_id, string $type): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity(["activity_id" => $activity_id, "type" => $type, ]);
    }
    /**
     * 用户加入活动
     */
    public static function joinActivity (int $activity_id,  $user_info, int $member_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinActivity(["activity_id" => $activity_id, "user_info" => $user_info, "member_id" => $member_id, ]);
    }
    /**
     * 获取活动发起者的活动信息
     */
    public static function getSponsorActivityInfo (int $activity_id, int $user_id, bool $with_relation_members, string $relation_members_sort): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSponsorActivityInfo(["activity_id" => $activity_id, "user_id" => $user_id, "with_relation_members" => $with_relation_members, "relation_members_sort" => $relation_members_sort, ]);
    }
    /**
     * 获取活动助力者的活动信息
     */
    public static function getInviteeActivityInfo (int $activity_id, int $member_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInviteeActivityInfo(["activity_id" => $activity_id, "member_id" => $member_id, ]);
    }
    /**
     * 校验当前用户是否需要消费才能加入活动
     */
    public static function canJoinByNeedConsume (int $activity_id, int $is_sponsor): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedConsume(["activity_id" => $activity_id, "is_sponsor" => $is_sponsor, ]);
    }
    /**
     * 校验当前用户是否是当前活动品牌的新用户
     */
    public static function canJoinByRegisteredFrom (int $activity_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByRegisteredFrom(["activity_id" => $activity_id, ]);
    }
    /**
     * 校验当前用户是否是当前活动品牌的新用户
     */
    public static function canJoinByNeedNewUser (int $activity_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedNewUser(["activity_id" => $activity_id, ]);
    }
    /**
     * 获取拼团列表
     */
    public static function joinGroupList (int $activity_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinGroupList(["activity_id" => $activity_id, ]);
    }
    /**
     * 检查活动信息--预约端调用
     */
    public static function checkActivityInfo (int $activity_id, float $group_buy_discount, array $group_buy_products, array $products_detail, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkActivityInfo(["activity_id" => $activity_id, "group_buy_discount" => $group_buy_discount, "group_buy_products" => $group_buy_products, "products_detail" => $products_detail, "user_id" => $user_id, ]);
    }
    /**
     * 检查限时购活动信息
     */
    public static function checkLimitedTimeBuy (int $activity_id, array $products_detail): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkLimitedTimeBuy(["activity_id" => $activity_id, "products_detail" => $products_detail, ]);
    }
    /**
     * 检查活动信息--web
     */
    public static function checkActivityInfoForWeb (int $activity_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkActivityInfoForWeb(["activity_id" => $activity_id, ]);
    }
    /**
     * 用户拼团订单列表
     */
    public static function groupBuyOrderList (int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->groupBuyOrderList(["page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 查找用户未支付的团购订单
     */
    public static function searchUserGroupBuySubmittedOrder (int $activity_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchUserGroupBuySubmittedOrder(["activity_id" => $activity_id, ]);
    }
    /**
     * 查找用户的历史邀请记录
     */
    public static function findInvitedHistoryRecords (int $activity_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findInvitedHistoryRecords(["activity_id" => $activity_id, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 查找用户当前活动的邀请记录
     */
    public static function findInvitedRecords (int $activity_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findInvitedRecords(["activity_id" => $activity_id, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取活动折扣产品组列表
     */
    public static function discountProductCategoryList (int $activity_id, int $city_id = 0): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->discountProductCategoryList(["activity_id" => $activity_id, "city_id" => $city_id, ]);
    }
    /**
     * 是否可以任意时间段内预约
     */
    public static function canReservationAnytime (int $activity_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->canReservationAnytime(["activity_id" => $activity_id, ]);
    }
    /**
     * 检查产品是否参与限时购门店折扣
     */
    public static function checkProductParticipateStore (int $activity_id, array $products, int $store_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductParticipateStore(["activity_id" => $activity_id, "products" => $products, "store_id" => $store_id, ]);
    }
    /**
     * 获取当前门店下的活动优惠规则--限时购活动使用
     */
    public static function getStoreDiscountRules (int $activity_id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreDiscountRules(["activity_id" => $activity_id, "store_id" => $store_id, ]);
    }
    /**
     * 获取发起人生成的小程序码
     */
    public static function getShareUserMiniProgramQrcode (string $app_name, string $path): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShareUserMiniProgramQrcode(["app_name" => $app_name, "path" => $path, ]);
    }
    /**
     * 渲染会员小程序首页
     */
    public static function homepage (int $page = 1, int $page_size = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->homepage(["page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 校验当前用户是否满足会员等级限制
     */
    public static function canJoinByNeedVipLimit (int $activity_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->canJoinByNeedVipLimit(["activity_id" => $activity_id, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}