<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-11 11:17:46
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ActivityManage
 */
class ActivityManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Activity\\ActivityManage";

    /**
     * 创建活动
     *
     */
    public static function createActivity (string $brand, string $title, string $type, string $started_at, string $ended_at, array $page_setting, array $rule_setting, array $extend): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->createActivity(["brand" => $brand, "title" => $title, "type" => $type, "started_at" => $started_at, "ended_at" => $ended_at, "page_setting" => $page_setting, "rule_setting" => $rule_setting, "extend" => $extend, ]);
    }
    /**
     * 编辑活动
     *
     */
    public static function updateActivity (int $activity_id, string $brand, string $title, string $started_at, string $ended_at, array $page_setting, array $rule_setting, array $extend): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateActivity(["activity_id" => $activity_id, "brand" => $brand, "title" => $title, "started_at" => $started_at, "ended_at" => $ended_at, "page_setting" => $page_setting, "rule_setting" => $rule_setting, "extend" => $extend, ]);
    }
    /**
     * 获取活动列表
     *
     */
    public static function list (string $brand, int $status, string $title, int $activity_id, string $type, int $page = 1, int $page_size = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["brand" => $brand, "status" => $status, "title" => $title, "activity_id" => $activity_id, "type" => $type, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取指定的活动详情
     *
     */
    public static function getActivity (int $activity_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity(["activity_id" => $activity_id, ]);
    }
    /**
     * 获取小程序二维码
     *
     */
    public static function getMiniProgramQrcode (string $path, string $appName): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniProgramQrcode(["path" => $path, "appName" => $appName, ]);
    }
    /**
     * 获取活动小程序UrlLink
     *
     */
    public static function getActivityMiniUrlLink (int $activity_id, string $path) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityMiniUrlLink(["activity_id" => $activity_id, "path" => $path, ]);
    }
    /**
     * 增加活动产品库存-目前限拼团及限时购活动
     *
     */
    public static function addProductBuyNum (int $activity_id, int $product_category_id, int $num): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductBuyNum(["activity_id" => $activity_id, "product_category_id" => $product_category_id, "num" => $num, ]);
    }
    /**
     * 获取未结束的活动--bms使用
     *
     */
    public static function getUnfinishedActivities (array $types, string $brand): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnfinishedActivities(["types" => $types, "brand" => $brand, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}