<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-10 16:03:59
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Member
 */
class Member {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Member\\Member";

    /**
     * 获取会员列表
     *
     */
    public static function memberList (string $user_sex, string $regis_source, array $attent_pub_account, string $user_level, array $user_levels, array $life_circle_label, string $user_phone, string $register_start, string $register_end, int $page = 1, int $page_size = 5, string $sort_by = 'user_regis_time', string $sort_type = 'desc') {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberList(["user_sex" => $user_sex, "regis_source" => $regis_source, "attent_pub_account" => $attent_pub_account, "user_level" => $user_level, "user_levels" => $user_levels, "life_circle_label" => $life_circle_label, "user_phone" => $user_phone, "register_start" => $register_start, "register_end" => $register_end, "page" => $page, "page_size" => $page_size, "sort_by" => $sort_by, "sort_type" => $sort_type, ]);
    }
    /**
     * 获取会员基础信息
     *
     */
    public static function memberElementaryMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberElementaryMessage(["user_id" => $user_id, ]);
    }
    /**
     * 获取会员聚合信息(从es获取的统计类数据)
     *
     */
    public static function memberEsMessage (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberEsMessage(["user_id" => $user_id, ]);
    }
    /**
     * 按品牌获取订单列表
     *
     */
    public static function memberOrderList (int $user_id, string $brand, int $page = 1, int $page_size = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->memberOrderList(["user_id" => $user_id, "brand" => $brand, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 补发生日券
     *
     */
    public static function sendBirthCoupon (int $userId, string $birthDate, int $stepYear = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendBirthCoupon(["userId" => $userId, "birthDate" => $birthDate, "stepYear" => $stepYear, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}